/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMACHashUtilities {
    public byte[] hash(byte[] key, byte[] data) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            SecretKeySpec hmacKey = new SecretKeySpec(key, "HmacSHA256");
            hmacSha256.init(hmacKey);
            return hmacSha256.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            Logger.getLogger(HMACHashUtilities.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] hash(SecretKey hmacKey, byte[] data) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256", PowerAuthConfiguration.INSTANCE.getKeyConvertor().getProviderName());
            hmacSha256.init(hmacKey);
            return hmacSha256.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            Logger.getLogger(HMACHashUtilities.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

