/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.util;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class ECPublicKeyFingerprint {
    public static String compute(ECPublicKey publicKey) throws NoSuchAlgorithmException {
        MessageDigest digest;
        byte[] hash;
        byte[] devicePublicKeyBytes = publicKey.getW().getAffineX().toByteArray();
        if (devicePublicKeyBytes[0] == 0) {
            devicePublicKeyBytes = Arrays.copyOfRange(devicePublicKeyBytes, 1, 33);
        }
        if ((hash = (digest = MessageDigest.getInstance("SHA-256")).digest(devicePublicKeyBytes)).length < 4) {
            throw new IndexOutOfBoundsException();
        }
        int index = hash.length - 4;
        int number = (ByteBuffer.wrap(hash).getInt(index) & Integer.MAX_VALUE) % (int)Math.pow(10.0, 8.0);
        String fingerprint = String.format("%08d", number);
        return fingerprint;
    }
}

