/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.generator;

import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.UUID;

public class IdentifierGenerator {
    private final SecureRandom secureRandom = new SecureRandom();

    public String generateActivationId() {
        return UUID.randomUUID().toString();
    }

    public String generateActivationIdShort() {
        return this.generateBase32Token(5, this.secureRandom) + "-" + this.generateBase32Token(5, this.secureRandom);
    }

    public String generateActivationOTP() {
        return this.generateBase32Token(5, this.secureRandom) + "-" + this.generateBase32Token(5, this.secureRandom);
    }

    private String generateBase32Token(int length, SecureRandom random) {
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        return BaseEncoding.base32().omitPadding().encode(randomBytes).substring(0, length);
    }
}

