/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor.ecies.kdf;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.util.Hash;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class KdfX9_63 {
    public static byte[] derive(byte[] secret, byte[] info, int outputBytes) {
        if (secret == null) {
            return null;
        }
        byte[] result = new byte[]{};
        byte[] round = new byte[secret.length + 4 + (info == null ? 0 : info.length)];
        int i = 1;
        while (result.length < outputBytes) {
            byte[] temp;
            System.arraycopy(secret, 0, round, 0, secret.length);
            byte[] counter = ByteBuffer.allocate(4).putInt(i).array();
            System.arraycopy(counter, 0, round, secret.length, 4);
            if (info != null) {
                System.arraycopy(info, 0, round, secret.length + 4, info.length);
            }
            if ((temp = Hash.sha256(round)) == null || temp.length == 0) {
                result = new byte[]{};
                break;
            }
            result = Bytes.concat((byte[][])new byte[][]{result, temp});
            ++i;
        }
        if (result.length > outputBytes) {
            result = Arrays.copyOf(result, outputBytes);
        }
        return result;
    }
}

