/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor.ecies;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.exception.EciesException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.kdf.KdfX9_63;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesPayload;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public class BasicEciesEncryptor {
    private AESEncryptionUtils aes = new AESEncryptionUtils();
    private HMACHashUtilities hmac = new HMACHashUtilities();
    private CryptoProviderUtil keyConverter = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private KeyGenerator keyGenerator = new KeyGenerator();
    private PublicKey publicKey;
    private KeyPair ephemeralKeyPair;
    private byte[] ephemeralDerivedSecretKey;
    private byte[] sharedInfo2;
    private boolean canEncryptData;
    private boolean canDecryptData;

    public BasicEciesEncryptor(ECPublicKey publicKey) {
        this(publicKey, null);
    }

    public BasicEciesEncryptor(ECPublicKey publicKey, byte[] sharedInfo2) {
        this.publicKey = publicKey;
        this.sharedInfo2 = sharedInfo2;
        this.canEncryptData = true;
        this.canDecryptData = false;
        this.ephemeralKeyPair = this.keyGenerator.generateKeyPair();
    }

    public PublicKey getEphemeralPublicKey() {
        return this.ephemeralKeyPair.getPublic();
    }

    public EciesPayload encrypt(byte[] data, byte[] info) throws EciesException {
        try {
            if (!this.canEncryptData) {
                throw new EciesException("This encryptor instance was already used");
            }
            if (this.ephemeralKeyPair == null) {
                throw new EciesException("Unable to generate an ephemeral key pair");
            }
            PrivateKey ephemeralKeyPrivate = this.ephemeralKeyPair.getPrivate();
            PublicKey ephemeralPublicKey = this.getEphemeralPublicKey();
            SecretKey ephemeralSecretKey = this.keyGenerator.computeSharedKey(ephemeralKeyPrivate, this.publicKey, true);
            this.ephemeralDerivedSecretKey = KdfX9_63.derive(this.keyConverter.convertSharedSecretKeyToBytes(ephemeralSecretKey), info, 32);
            byte[] encKeyBytes = Arrays.copyOf(this.ephemeralDerivedSecretKey, 16);
            SecretKey encKey = this.keyConverter.convertBytesToSharedSecretKey(encKeyBytes);
            byte[] iv = new byte[16];
            byte[] body = this.aes.encrypt(data, iv, encKey);
            byte[] macKeyBytes = Arrays.copyOfRange(this.ephemeralDerivedSecretKey, 16, 32);
            byte[] macData = this.sharedInfo2 == null ? body : Bytes.concat((byte[][])new byte[][]{body, this.sharedInfo2});
            byte[] mac = this.hmac.hash(macKeyBytes, macData);
            this.canEncryptData = false;
            this.canDecryptData = true;
            return new EciesPayload(ephemeralPublicKey, mac, body);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new EciesException("Decryption error occurred", e);
        }
    }

    public byte[] decrypt(EciesPayload payload) throws EciesException {
        try {
            byte[] macData;
            if (!this.canDecryptData) {
                throw new EciesException("This encryptor instance was already used");
            }
            byte[] macKeyBytes = Arrays.copyOfRange(this.ephemeralDerivedSecretKey, 16, 32);
            byte[] mac = this.hmac.hash(macKeyBytes, macData = this.sharedInfo2 == null ? payload.getEncryptedData() : Bytes.concat((byte[][])new byte[][]{payload.getEncryptedData(), this.sharedInfo2}));
            if (!Arrays.equals(mac, payload.getMac())) {
                throw new EciesException("Invalid MAC");
            }
            byte[] encKeyBytes = Arrays.copyOf(this.ephemeralDerivedSecretKey, 16);
            SecretKey encKey = this.keyConverter.convertBytesToSharedSecretKey(encKeyBytes);
            byte[] iv = new byte[16];
            this.canDecryptData = false;
            return this.aes.decrypt(payload.getEncryptedData(), iv, encKey);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new EciesException("Decryption error occurred", e);
        }
    }
}

