/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor.ecies;

import com.google.common.primitives.Bytes;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.exception.EciesException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.kdf.KdfX9_63;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.model.EciesPayload;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public class BasicEciesDecryptor {
    private AESEncryptionUtils aes = new AESEncryptionUtils();
    private HMACHashUtilities hmac = new HMACHashUtilities();
    private KeyGenerator keyGenerator = new KeyGenerator();
    private CryptoProviderUtil keyConverter = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
    private PrivateKey privateKey;
    private byte[] sharedInfo2;
    private PublicKey ephemeralPublicKey;
    private boolean canDecryptData;
    private boolean canEncryptData;

    public BasicEciesDecryptor(ECPrivateKey encryptionPrivateKey) {
        this(encryptionPrivateKey, null);
    }

    public BasicEciesDecryptor(ECPrivateKey encryptionPrivateKey, byte[] sharedInfo2) {
        this.privateKey = encryptionPrivateKey;
        this.sharedInfo2 = sharedInfo2;
        this.canDecryptData = true;
        this.canEncryptData = false;
    }

    public byte[] decrypt(EciesPayload payload, byte[] info) throws EciesException {
        try {
            byte[] macData;
            if (!this.canDecryptData) {
                throw new EciesException("This decryptor instance was already used");
            }
            this.ephemeralPublicKey = payload.getEphemeralPublicKey();
            SecretKey secretKey = this.keyGenerator.computeSharedKey(this.privateKey, this.ephemeralPublicKey, true);
            byte[] ephemeralDerivedSecretKey = KdfX9_63.derive(this.keyConverter.convertSharedSecretKeyToBytes(secretKey), info, 32);
            byte[] macKeyBytes = Arrays.copyOfRange(ephemeralDerivedSecretKey, 16, 32);
            byte[] mac = this.hmac.hash(macKeyBytes, macData = this.sharedInfo2 == null ? payload.getEncryptedData() : Bytes.concat((byte[][])new byte[][]{payload.getEncryptedData(), this.sharedInfo2}));
            if (!Arrays.equals(mac, payload.getMac())) {
                throw new EciesException("Invalid MAC");
            }
            byte[] encKeyBytes = Arrays.copyOf(ephemeralDerivedSecretKey, 16);
            SecretKey encKey = this.keyConverter.convertBytesToSharedSecretKey(encKeyBytes);
            byte[] iv = new byte[16];
            this.canDecryptData = false;
            this.canEncryptData = true;
            return this.aes.decrypt(payload.getEncryptedData(), iv, encKey);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new EciesException("Decryption error occurred", e);
        }
    }

    public EciesPayload encrypt(byte[] data, byte[] info) throws EciesException {
        try {
            if (!this.canEncryptData) {
                throw new EciesException("This decryptor instance was already used");
            }
            SecretKey secretKey = this.keyGenerator.computeSharedKey(this.privateKey, this.ephemeralPublicKey, true);
            byte[] ephemeralDerivedSecretKey = KdfX9_63.derive(this.keyConverter.convertSharedSecretKeyToBytes(secretKey), info, 32);
            byte[] encKeyBytes = Arrays.copyOf(ephemeralDerivedSecretKey, 16);
            SecretKey encKey = this.keyConverter.convertBytesToSharedSecretKey(encKeyBytes);
            byte[] iv = new byte[16];
            byte[] body = this.aes.encrypt(data, iv, encKey);
            byte[] macKeyBytes = Arrays.copyOfRange(ephemeralDerivedSecretKey, 16, 32);
            byte[] macData = this.sharedInfo2 == null ? body : Bytes.concat((byte[][])new byte[][]{body, this.sharedInfo2});
            byte[] mac = this.hmac.hash(macKeyBytes, macData);
            this.canEncryptData = false;
            return new EciesPayload(this.ephemeralPublicKey, mac, body);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new EciesException("Decryption error occurred", e);
        }
    }

    public EciesPayload encrypt(byte[] data, ECPublicKey ephemeralPublicKey, byte[] info) throws EciesException {
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.canDecryptData = false;
        this.canEncryptData = true;
        return this.encrypt(data, info);
    }
}

