/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.lib.encryptor;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public class NonPersonalizedEncryptor {
    private static final int MAX_ATTEMPT_COUNT = 1000;
    private byte[] applicationKey;
    private byte[] sessionIndex;
    private byte[] sessionRelatedSecretKey;
    private byte[] ephemeralPublicKey;
    private AESEncryptionUtils aes = new AESEncryptionUtils();
    private KeyGenerator generator = new KeyGenerator();
    private HMACHashUtilities hmac = new HMACHashUtilities();
    private CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();

    public NonPersonalizedEncryptor(byte[] applicationKey, byte[] sessionRelatedSecretKey, byte[] sessionIndex, byte[] ephemeralPublicKeyString) {
        this.applicationKey = applicationKey;
        this.sessionIndex = sessionIndex;
        this.sessionRelatedSecretKey = sessionRelatedSecretKey;
        this.ephemeralPublicKey = ephemeralPublicKeyString;
    }

    public NonPersonalizedEncryptedMessage encrypt(byte[] originalData) {
        try {
            byte[] adHocIndex = this.generator.generateRandomBytes(16);
            byte[] macIndex = this.generator.generateRandomBytes(16);
            int attemptCount = 0;
            while (Arrays.equals(adHocIndex, macIndex)) {
                macIndex = this.generator.generateRandomBytes(16);
                if (attemptCount < 1000) {
                    ++attemptCount;
                    continue;
                }
                return null;
            }
            byte[] nonce = this.generator.generateRandomBytes(16);
            SecretKey sessionKey = this.keyConversion.convertBytesToSharedSecretKey(this.sessionRelatedSecretKey);
            SecretKey encryptionKey = this.generator.deriveSecretKeyHmac(sessionKey, adHocIndex);
            SecretKey macKey = this.generator.deriveSecretKeyHmac(sessionKey, macIndex);
            byte[] encryptedData = this.aes.encrypt(originalData, nonce, encryptionKey);
            byte[] mac = this.hmac.hash(macKey, encryptedData);
            NonPersonalizedEncryptedMessage message = new NonPersonalizedEncryptedMessage();
            message.setApplicationKey(this.applicationKey);
            message.setEphemeralPublicKey(this.ephemeralPublicKey);
            message.setSessionIndex(this.sessionIndex);
            message.setAdHocIndex(adHocIndex);
            message.setMacIndex(macIndex);
            message.setNonce(nonce);
            message.setEncryptedData(encryptedData);
            message.setMac(mac);
            return message;
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(NonPersonalizedEncryptor.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] decrypt(NonPersonalizedEncryptedMessage message) {
        try {
            byte[] adHocIndex = message.getAdHocIndex();
            byte[] macIndex = message.getMacIndex();
            if (Arrays.equals(adHocIndex, macIndex)) {
                return null;
            }
            byte[] nonce = message.getNonce();
            SecretKey sessionKey = this.keyConversion.convertBytesToSharedSecretKey(this.sessionRelatedSecretKey);
            SecretKey encryptionKey = this.generator.deriveSecretKeyHmac(sessionKey, adHocIndex);
            SecretKey macKey = this.generator.deriveSecretKeyHmac(sessionKey, macIndex);
            byte[] encryptedData = message.getEncryptedData();
            byte[] macExpected = this.hmac.hash(macKey, encryptedData);
            byte[] mac = message.getMac();
            if (!Arrays.equals(mac, macExpected)) {
                return null;
            }
            return this.aes.decrypt(encryptedData, nonce, encryptionKey);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(NonPersonalizedEncryptor.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(byte[] applicationKey) {
        this.applicationKey = applicationKey;
    }

    public byte[] getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(byte[] sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public byte[] getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public void setEphemeralPublicKey(byte[] ephemeralPublicKey) {
        this.ephemeralPublicKey = ephemeralPublicKey;
    }

    public byte[] getSessionRelatedSecretKey() {
        return this.sessionRelatedSecretKey;
    }

    public void setSessionRelatedSecretKey(byte[] sessionRelatedSecretKey) {
        this.sessionRelatedSecretKey = sessionRelatedSecretKey;
    }
}

