/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.vault;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public class PowerAuthClientVault {
    public SecretKey decryptVaultEncryptionKey(byte[] cVaultEncryptionKey, SecretKey masterTransportKey, long ctr) throws InvalidKeyException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        CryptoProviderUtil keyConvertor = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
        KeyGenerator keyGen = new KeyGenerator();
        SecretKey vaultEncryptionTransportKey = keyGen.deriveSecretKey(masterTransportKey, ctr);
        byte[] zeroBytes = new byte[16];
        try {
            byte[] keyBytes = aes.decrypt(cVaultEncryptionKey, zeroBytes, vaultEncryptionTransportKey);
            return keyConvertor.convertBytesToSharedSecretKey(keyBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthClientVault.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] encryptDevicePrivateKey(PrivateKey devicePrivateKey, SecretKey vaultEncryptionKey) throws InvalidKeyException {
        try {
            AESEncryptionUtils aes = new AESEncryptionUtils();
            CryptoProviderUtil keyConvertor = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
            byte[] devicePrivateKeyBytes = keyConvertor.convertPrivateKeyToBytes(devicePrivateKey);
            byte[] zeroBytes = new byte[16];
            return aes.encrypt(devicePrivateKeyBytes, zeroBytes, vaultEncryptionKey);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthClientVault.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public PrivateKey decryptDevicePrivateKey(byte[] cDevicePrivateKey, SecretKey vaultEncryptionKey) throws InvalidKeyException {
        AESEncryptionUtils aes = new AESEncryptionUtils();
        CryptoProviderUtil keyConvertor = PowerAuthConfiguration.INSTANCE.getKeyConvertor();
        byte[] zeroBytes = new byte[16];
        try {
            byte[] keyBytes = aes.decrypt(cDevicePrivateKey, zeroBytes, vaultEncryptionKey);
            return keyConvertor.convertBytesToPrivateKey(keyBytes);
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthClientVault.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

