/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.encryptor;

import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.encryptor.NonPersonalizedEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.NonPersonalizedEncryptedMessage;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.provider.CryptoProviderUtil;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class ClientNonPersonalizedEncryptor {
    private NonPersonalizedEncryptor encryptor;
    private KeyGenerator generator = new KeyGenerator();
    private CryptoProviderUtil keyConversion = PowerAuthConfiguration.INSTANCE.getKeyConvertor();

    public ClientNonPersonalizedEncryptor(byte[] appKey, PublicKey masterPublicKey) throws InvalidKeyException {
        byte[] sessionIndex = this.generator.generateRandomBytes(16);
        KeyPair ephemeralKeyPair = this.generator.generateKeyPair();
        if (ephemeralKeyPair == null) {
            throw new InvalidKeyException("Unable to generate EC key pair. Check your Bouncy Castle settings.");
        }
        SecretKey ephemeralSecretKey = this.generator.computeSharedKey(ephemeralKeyPair.getPrivate(), masterPublicKey);
        SecretKey sessionRelatedSecretKey = this.generator.deriveSecretKeyHmac(ephemeralSecretKey, sessionIndex);
        byte[] sessionRelatedSecretKeyBytes = this.keyConversion.convertSharedSecretKeyToBytes(sessionRelatedSecretKey);
        byte[] ephemeralPublicKeyBytes = this.keyConversion.convertPublicKeyToBytes(ephemeralKeyPair.getPublic());
        this.encryptor = new NonPersonalizedEncryptor(appKey, sessionRelatedSecretKeyBytes, sessionIndex, ephemeralPublicKeyBytes);
    }

    public NonPersonalizedEncryptedMessage encrypt(byte[] data) {
        return this.encryptor.encrypt(data);
    }

    public byte[] decrypt(NonPersonalizedEncryptedMessage message) {
        return this.encryptor.decrypt(message);
    }
}

