/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.crypto.client.activation;

import com.google.common.io.BaseEncoding;
import io.getlime.security.powerauth.crypto.lib.config.PowerAuthConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.model.ActivationStatusBlobInfo;
import io.getlime.security.powerauth.crypto.lib.util.AESEncryptionUtils;
import io.getlime.security.powerauth.crypto.lib.util.ECPublicKeyFingerprint;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.SignatureUtils;
import io.getlime.security.powerauth.crypto.server.activation.PowerAuthServerActivation;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

public class PowerAuthClientActivation {
    private final SignatureUtils signatureUtils = new SignatureUtils();

    public boolean verifyActivationDataSignature(String activationIdShort, String activationOTP, byte[] signature, PublicKey masterPublicKey) throws InvalidKeyException {
        try {
            byte[] bytes = (activationIdShort + "-" + activationOTP).getBytes("UTF-8");
            return this.signatureUtils.validateECDSASignature(bytes, signature, masterPublicKey);
        }
        catch (UnsupportedEncodingException | SignatureException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public KeyPair generateDeviceKeyPair() {
        return new KeyGenerator().generateKeyPair();
    }

    public byte[] generateActivationNonce() {
        return new KeyGenerator().generateRandomBytes(16);
    }

    public byte[] computeApplicationSignature(String activationIdShort, byte[] activationNonce, byte[] encryptedDevicePublicKey, byte[] applicationKey, byte[] applicationSecret) {
        try {
            String signatureBaseString = activationIdShort + "&" + BaseEncoding.base64().encode(activationNonce) + "&" + BaseEncoding.base64().encode(encryptedDevicePublicKey) + "&" + BaseEncoding.base64().encode(applicationKey);
            return new HMACHashUtilities().hash(applicationSecret, signatureBaseString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] encryptDevicePublicKey(PublicKey devicePublicKey, PrivateKey clientEphemeralPrivateKey, PublicKey masterPublicKey, String activationOTP, String activationIdShort, byte[] activationNonce) throws InvalidKeyException {
        try {
            KeyGenerator keyGenerator = new KeyGenerator();
            byte[] activationIdShortBytes = activationIdShort.getBytes("UTF-8");
            SecretKey otpBasedSymmetricKey = keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
            byte[] devicePubKeyBytes = PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertPublicKeyToBytes(devicePublicKey);
            SecretKey ephemeralKey = keyGenerator.computeSharedKey(clientEphemeralPrivateKey, masterPublicKey);
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] tmpData = aes.encrypt(devicePubKeyBytes, activationNonce, otpBasedSymmetricKey);
            return aes.encrypt(tmpData, activationNonce, ephemeralKey);
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public boolean verifyServerDataSignature(String activationId, byte[] C_serverPublicKey, byte[] signature, PublicKey masterPublicKey) throws InvalidKeyException, UnsupportedEncodingException {
        try {
            byte[] activationIdBytes = activationId.getBytes("UTF-8");
            String activationIdBytesBase64 = BaseEncoding.base64().encode(activationIdBytes);
            String C_serverPublicKeyBase64 = BaseEncoding.base64().encode(C_serverPublicKey);
            byte[] result = (activationIdBytesBase64 + "&" + C_serverPublicKeyBase64).getBytes("UTF-8");
            return this.signatureUtils.validateECDSASignature(result, signature, masterPublicKey);
        }
        catch (SignatureException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public PublicKey decryptServerPublicKey(byte[] C_serverPublicKey, PrivateKey devicePrivateKey, PublicKey ephemeralPublicKey, String activationOTP, String activationIdShort, byte[] activationNonce) throws InvalidKeyException {
        try {
            KeyGenerator keyGenerator = new KeyGenerator();
            SecretKey ephemeralSymmetricKey = keyGenerator.computeSharedKey(devicePrivateKey, ephemeralPublicKey);
            byte[] activationIdShortBytes = activationIdShort.getBytes("UTF-8");
            SecretKey otpBasedSymmetricKey = keyGenerator.deriveSecretKeyFromPassword(activationOTP, activationIdShortBytes);
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] decryptedTMP = aes.decrypt(C_serverPublicKey, activationNonce, ephemeralSymmetricKey);
            byte[] decryptedServerPublicKeyBytes = aes.decrypt(decryptedTMP, activationNonce, otpBasedSymmetricKey);
            return PowerAuthConfiguration.INSTANCE.getKeyConvertor().convertBytesToPublicKey(decryptedServerPublicKeyBytes);
        }
        catch (UnsupportedEncodingException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String computeDevicePublicKeyFingerprint(PublicKey devicePublicKey) {
        try {
            return ECPublicKeyFingerprint.compute((ECPublicKey)devicePublicKey);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(PowerAuthServerActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ActivationStatusBlobInfo getStatusFromEncryptedBlob(byte[] cStatusBlob, SecretKey transportKey) throws InvalidKeyException {
        try {
            if (cStatusBlob.length != 32) {
                ActivationStatusBlobInfo statusInfo = new ActivationStatusBlobInfo();
                statusInfo.setActivationStatus((byte)5);
                statusInfo.setCounter(0L);
                statusInfo.setFailedAttempts((byte)0);
                statusInfo.setMaxFailedAttempts((byte)5);
                statusInfo.setValid(false);
                return statusInfo;
            }
            AESEncryptionUtils aes = new AESEncryptionUtils();
            byte[] zeroIv = new byte[16];
            byte[] statusBlob = aes.decrypt(cStatusBlob, zeroIv, transportKey, "AES/CBC/NoPadding");
            ActivationStatusBlobInfo statusInfo = new ActivationStatusBlobInfo();
            ByteBuffer buffer = ByteBuffer.wrap(statusBlob);
            int prefix = buffer.getInt(0);
            statusInfo.setValid(prefix == -557785391);
            statusInfo.setActivationStatus(buffer.get(4));
            statusInfo.setCounter(buffer.getLong(5));
            statusInfo.setFailedAttempts(buffer.get(13));
            statusInfo.setMaxFailedAttempts(buffer.get(14));
            return statusInfo;
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(PowerAuthClientActivation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

