/*
 * Decompiled with CFR 0.152.
 */
package io.getconnect.client;

import io.getconnect.client.InvalidEventException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Event {
    protected final String reservedPrefix = "tp_";
    protected final Map<String, Object> eventData;
    protected String eventStoreId;

    public Event(Map<String, Object> eventData) {
        this(eventData, UUID.randomUUID().toString());
    }

    private Event(Map<String, Object> eventData, String eventStoreId) {
        this.eventData = eventData;
        this.eventStoreId = eventStoreId;
        this.setDefaultProperties();
        this.validateProperties();
    }

    public static Event fromEventStore(Map<String, Object> eventData, String eventStoreId) {
        return new Event(eventData, eventStoreId);
    }

    public Map<String, Object> getEventData() {
        return this.eventData;
    }

    public String getId() {
        return this.eventData.get("id").toString();
    }

    public String getEventStoreId() {
        return this.eventStoreId;
    }

    protected void setDefaultProperties() {
        if (!this.eventData.containsKey("id")) {
            this.eventData.put("id", UUID.randomUUID().toString());
        }
        if (!this.eventData.containsKey("timestamp")) {
            this.eventData.put("timestamp", new Date());
        }
    }

    protected void validateProperties() throws InvalidEventException {
        HashMap<String, String> invalidProperties = new HashMap<String, String>();
        for (String key : this.eventData.keySet()) {
            if (key.startsWith("tp_")) {
                invalidProperties.put(key, "Property names cannot start with the reserved prefix 'tp_'");
            }
            if (!key.contains(".")) continue;
            invalidProperties.put(key, "Property names cannot contain a period (.)");
        }
        if (!invalidProperties.isEmpty()) {
            throw InvalidEventException.create(invalidProperties);
        }
    }
}

