/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test.streaming;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.AbstractTestFixture;
import io.fluxcapacitor.javaclient.test.Then;
import io.fluxcapacitor.javaclient.test.streaming.AsyncResultValidator;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class StreamingTestFixture
extends AbstractTestFixture {
    public static Duration defaultVerificationTimeout = Duration.ofSeconds(2L);
    private final BlockingQueue<Message> events = new LinkedBlockingQueue<Message>();
    private final BlockingQueue<Message> commands = new LinkedBlockingQueue<Message>();
    private final BlockingQueue<Schedule> schedules = new LinkedBlockingQueue<Schedule>();
    private final ScheduledExecutorService deregistrationService = Executors.newSingleThreadScheduledExecutor();
    private Duration verificationTimeout = defaultVerificationTimeout;

    public static StreamingTestFixture create(Object ... handlers) {
        return new StreamingTestFixture(fc -> Arrays.asList(handlers));
    }

    public static StreamingTestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Object ... handlers) {
        return new StreamingTestFixture(fluxCapacitorBuilder, fc -> Arrays.asList(handlers));
    }

    public static StreamingTestFixture create(Function<FluxCapacitor, List<?>> handlersFactory) {
        return new StreamingTestFixture(handlersFactory);
    }

    public static StreamingTestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        return new StreamingTestFixture(fluxCapacitorBuilder, handlersFactory);
    }

    public static StreamingTestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Client client, Object ... handlers) {
        return new StreamingTestFixture(fluxCapacitorBuilder, fc -> Arrays.asList(handlers), client);
    }

    protected StreamingTestFixture(Function<FluxCapacitor, List<?>> handlersFactory) {
        super(handlersFactory);
    }

    protected StreamingTestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        super(fluxCapacitorBuilder, handlersFactory);
    }

    protected StreamingTestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory, Client client) {
        super(fluxCapacitorBuilder, handlersFactory, client);
    }

    @Override
    public Registration registerHandlers(List<?> handlers) {
        return this.getFluxCapacitor().registerHandlers(handlers);
    }

    @Override
    public void deregisterHandlers(Registration registration) {
        this.deregistrationService.schedule(() -> ((Registration)registration).cancel(), 1L, TimeUnit.SECONDS);
    }

    @Override
    protected Then createResultValidator(Object result) {
        return new AsyncResultValidator(this.getFluxCapacitor(), result, this.events, this.commands, this.schedules, this.verificationTimeout);
    }

    @Override
    protected void registerCommand(Message command) {
        this.commands.add(command);
    }

    @Override
    protected void registerEvent(Message event) {
        this.events.add(event);
    }

    @Override
    protected void registerSchedule(Schedule schedule) {
        this.schedules.add(schedule);
    }

    @Override
    protected Object getDispatchResult(CompletableFuture<?> dispatchResult) {
        try {
            return dispatchResult.get(this.verificationTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void setVerificationTimeout(Duration verificationTimeout) {
        this.verificationTimeout = verificationTimeout;
    }
}

