/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test.streaming;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.AbstractResultValidator;
import io.fluxcapacitor.javaclient.test.Then;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class AsyncResultValidator
extends AbstractResultValidator {
    private final BlockingQueue<Message> resultingEvents;
    private final BlockingQueue<Message> resultingCommands;
    private final BlockingQueue<Schedule> resultingSchedules;
    private final Duration verificationTimeout;

    public AsyncResultValidator(FluxCapacitor fluxCapacitor, Object actualResult, BlockingQueue<Message> resultingEvents, BlockingQueue<Message> resultingCommands, BlockingQueue<Schedule> resultingSchedules, Duration verificationTimeout) {
        super(fluxCapacitor, actualResult);
        this.resultingEvents = resultingEvents;
        this.resultingCommands = resultingCommands;
        this.resultingSchedules = resultingSchedules;
        this.verificationTimeout = verificationTimeout;
    }

    @Override
    public Then expectOnlyEvents(List<?> events) {
        return this.expectOnlyMessages((Collection<?>)events, this.resultingEvents);
    }

    @Override
    public Then expectEvents(List<?> events) {
        return this.expectMessages(events, this.resultingEvents);
    }

    @Override
    public Then expectNoEventsLike(List<?> events) {
        return this.expectNoMessagesLike((Collection<?>)events, this.resultingEvents);
    }

    @Override
    public Then expectOnlyCommands(List<?> commands) {
        return this.expectOnlyMessages((Collection<?>)commands, this.resultingCommands);
    }

    @Override
    public Then expectCommands(List<?> commands) {
        return this.expectMessages(commands, this.resultingCommands);
    }

    @Override
    public Then expectNoCommandsLike(List<?> commands) {
        return this.expectNoMessagesLike((Collection<?>)commands, this.resultingCommands);
    }

    @Override
    public Then expectOnlySchedules(List<?> schedules) {
        Collection<?> expected = this.asMessages(schedules);
        Collection<Schedule> actual = this.getActualMessages(expected, this.resultingSchedules);
        return this.expectOnlyScheduledMessages(expected, actual);
    }

    @Override
    public Then expectSchedules(List<?> schedules) {
        Collection<?> expected = this.asMessages(schedules);
        Collection<Schedule> actual = this.getActualMessages(expected, this.resultingSchedules);
        return this.expectScheduledMessages(expected, actual);
    }

    @Override
    public Then expectNoSchedulesLike(List<?> schedules) {
        return this.expectNoMessagesLike((Collection<?>)schedules, (Collection<? extends Message>)this.resultingSchedules);
    }

    protected Then expectMessages(List<?> messages, BlockingQueue<Message> resultingMessages) {
        Collection<?> expected = this.asMessages(messages);
        Collection<Message> actual = this.getActualMessages(expected, resultingMessages);
        return this.expectMessages(expected, actual);
    }

    protected Then expectOnlyMessages(Collection<?> messages, BlockingQueue<Message> resultingMessages) {
        Collection<?> expected = this.asMessages(messages);
        Collection<Message> actual = this.getActualMessages(expected, resultingMessages);
        return this.expectOnlyMessages(expected, actual);
    }

    protected Then expectNoMessagesLike(Collection<?> messages, BlockingQueue<Message> resultingMessages) {
        Collection<?> expected = this.asMessages(messages);
        Collection<Message> actual = this.getActualMessages(expected, resultingMessages);
        return this.expectNoMessagesLike(expected, actual);
    }

    protected <M extends Message> Collection<M> getActualMessages(Collection<?> expected, BlockingQueue<M> resultingMessages) {
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            while (!(!expected.isEmpty() && this.containsAll(expected, result) || Thread.interrupted())) {
                Message next = (Message)resultingMessages.poll(this.verificationTimeout.toMillis(), TimeUnit.MILLISECONDS);
                if (next == null) {
                    return result;
                }
                result.add(next);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return result;
        }
        return result;
    }
}

