/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test.spring;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.configuration.spring.FluxCapacitorSpringConfig;
import io.fluxcapacitor.javaclient.test.streaming.StreamingTestFixture;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={FluxCapacitorSpringConfig.class})
public class FluxCapacitorTestConfig {
    private static final Logger log = LoggerFactory.getLogger(FluxCapacitorTestConfig.class);
    private final ApplicationContext context;

    @Bean
    @Primary
    public FluxCapacitor fluxCapacitor(StreamingTestFixture testFixture) {
        return testFixture.getFluxCapacitor();
    }

    @Bean
    public StreamingTestFixture testFixture(FluxCapacitorBuilder fluxCapacitorBuilder) {
        fluxCapacitorBuilder.makeApplicationInstance(false);
        Client client = this.getBean(Client.class).orElseGet(() -> this.getBean(WebSocketClient.Properties.class).map(WebSocketClient::newInstance).orElse(null));
        if (client == null) {
            return StreamingTestFixture.create(fluxCapacitorBuilder, new Object[0]);
        }
        return StreamingTestFixture.create(fluxCapacitorBuilder, client, new Object[0]);
    }

    protected <T> Optional<T> getBean(Class<T> type) {
        return this.context.getBeansOfType(type).values().stream().findFirst();
    }

    @ConstructorProperties(value={"context"})
    public FluxCapacitorTestConfig(ApplicationContext context) {
        this.context = context;
    }
}

