/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.scheduling.DefaultScheduler;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.client.InMemorySchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.test.AbstractTestFixture;
import io.fluxcapacitor.javaclient.test.ResultValidator;
import io.fluxcapacitor.javaclient.test.Then;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFixture
extends AbstractTestFixture {
    private static final Logger log = LoggerFactory.getLogger(TestFixture.class);
    private final List<Message> events = new ArrayList<Message>();
    private final List<Message> commands = new ArrayList<Message>();
    private final List<Schedule> schedules = new ArrayList<Schedule>();

    public static TestFixture create(Object ... handlers) {
        return new TestFixture(fc -> Arrays.asList(handlers));
    }

    public static TestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Object ... handlers) {
        return new TestFixture(fluxCapacitorBuilder, fc -> Arrays.asList(handlers));
    }

    public static TestFixture create(Function<FluxCapacitor, List<?>> handlersFactory) {
        return new TestFixture(handlersFactory);
    }

    public static TestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        return new TestFixture(fluxCapacitorBuilder, handlersFactory);
    }

    protected TestFixture(Function<FluxCapacitor, List<?>> handlersFactory) {
        super(handlersFactory);
    }

    protected TestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        super(fluxCapacitorBuilder, handlersFactory);
    }

    @Override
    public Registration registerHandlers(List<?> handlers) {
        if (handlers.isEmpty()) {
            return Registration.noOp();
        }
        FluxCapacitor fluxCapacitor = this.getFluxCapacitor();
        HandlerConfiguration handlerConfiguration = HandlerConfiguration.defaultHandlerConfiguration();
        Registration registration = (Registration)fluxCapacitor.execute(f -> handlers.stream().flatMap(h -> Stream.of(fluxCapacitor.commandGateway().registerHandler(h, handlerConfiguration), fluxCapacitor.queryGateway().registerHandler(h, handlerConfiguration), fluxCapacitor.eventGateway().registerHandler(h, handlerConfiguration), fluxCapacitor.eventStore().registerHandler(h, handlerConfiguration), fluxCapacitor.errorGateway().registerHandler(h, handlerConfiguration))).reduce(Registration::merge).orElse(Registration.noOp()));
        if (fluxCapacitor.scheduler() instanceof DefaultScheduler) {
            DefaultScheduler scheduler = (DefaultScheduler)fluxCapacitor.scheduler();
            registration = registration.merge((Registration)fluxCapacitor.execute(fc -> handlers.stream().flatMap(h -> Stream.of(scheduler.registerHandler(h, handlerConfiguration))).reduce(Registration::merge).orElse(Registration.noOp())));
        } else {
            log.warn("Could not register local schedule handlers");
        }
        return registration;
    }

    @Override
    public void deregisterHandlers(Registration registration) {
        registration.cancel();
    }

    @Override
    protected Then createResultValidator(Object result) {
        return new ResultValidator(this.getFluxCapacitor(), result, this.events, this.commands, this.schedules);
    }

    @Override
    protected void registerCommand(Message command) {
        this.commands.add(command);
    }

    @Override
    protected void registerEvent(Message event) {
        this.events.add(event);
    }

    @Override
    protected void registerSchedule(Schedule schedule) {
        this.schedules.add(schedule);
    }

    @Override
    protected Object getDispatchResult(CompletableFuture<?> dispatchResult) {
        try {
            return dispatchResult.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (TimeoutException e) {
            throw new TimeoutException("Test fixture did not receive a dispatch result in time. Perhaps some messages did not have handlers?");
        }
    }

    @Override
    protected Then applyWhen(Callable<?> action, boolean catchAll) {
        this.getFluxCapacitor().execute(fc -> {
            this.handleExpiredSchedulesLocally();
            return null;
        });
        return super.applyWhen(() -> {
            Object result = action.call();
            this.handleExpiredSchedulesLocally();
            return result;
        }, catchAll);
    }

    protected void handleExpiredSchedulesLocally() {
        SchedulingClient schedulingClient = this.getFluxCapacitor().client().getSchedulingClient();
        if (schedulingClient instanceof InMemorySchedulingClient) {
            List expiredSchedules = ((InMemorySchedulingClient)schedulingClient).removeExpiredSchedules(this.getFluxCapacitor().serializer());
            if (this.getFluxCapacitor().scheduler() instanceof DefaultScheduler) {
                DefaultScheduler scheduler = (DefaultScheduler)this.getFluxCapacitor().scheduler();
                expiredSchedules.forEach(s -> scheduler.handleLocally(s, s.serialize(this.getFluxCapacitor().serializer())));
            }
        }
    }
}

