/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.configuration.DefaultFluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.client.InMemorySchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.test.Given;
import io.fluxcapacitor.javaclient.test.TestClient;
import io.fluxcapacitor.javaclient.test.TestUserProvider;
import io.fluxcapacitor.javaclient.test.Then;
import io.fluxcapacitor.javaclient.test.When;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestFixture
implements Given,
When {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestFixture.class);
    private final FluxCapacitor fluxCapacitor;
    private final Registration registration;
    private final GivenWhenThenInterceptor interceptor;

    protected AbstractTestFixture(Function<FluxCapacitor, List<?>> handlerFactory) {
        this((FluxCapacitorBuilder)DefaultFluxCapacitor.builder(), handlerFactory);
    }

    protected AbstractTestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlerFactory) {
        this(fluxCapacitorBuilder, handlerFactory, (Client)new TestClient());
    }

    protected AbstractTestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlerFactory, Client client) {
        Optional<TestUserProvider> userProvider = Optional.ofNullable(UserProvider.defaultUserSupplier).map(TestUserProvider::new);
        if (userProvider.isPresent()) {
            fluxCapacitorBuilder = fluxCapacitorBuilder.registerUserSupplier((UserProvider)userProvider.get());
        }
        this.interceptor = new GivenWhenThenInterceptor();
        this.fluxCapacitor = fluxCapacitorBuilder.disableShutdownHook().addDispatchInterceptor((DispatchInterceptor)this.interceptor, new MessageType[0]).build(client);
        this.withClock(Clock.fixed(Instant.now(), ZoneId.systemDefault()));
        this.registration = this.registerHandlers(handlerFactory.apply(this.fluxCapacitor));
    }

    public abstract Registration registerHandlers(List<?> var1);

    public abstract void deregisterHandlers(Registration var1);

    protected abstract Then createResultValidator(Object var1);

    protected abstract void registerCommand(Message var1);

    protected abstract void registerEvent(Message var1);

    protected abstract void registerSchedule(Schedule var1);

    protected abstract Object getDispatchResult(CompletableFuture<?> var1);

    @Override
    public Given withClock(Clock clock) {
        return (Given)this.getFluxCapacitor().execute(fc -> {
            fc.withClock(clock);
            SchedulingClient schedulingClient = fc.client().getSchedulingClient();
            if (schedulingClient instanceof InMemorySchedulingClient) {
                ((InMemorySchedulingClient)schedulingClient).setClock(clock);
            } else {
                log.warn("Could not update clock of scheduling client. Timing tests may not work.");
            }
            return this;
        });
    }

    @Override
    public Clock getClock() {
        return this.getFluxCapacitor().clock();
    }

    @Override
    public When givenCommands(Object ... commands) {
        return this.given(() -> this.getDispatchResult(CompletableFuture.allOf((CompletableFuture[])this.flatten(commands).map(c -> this.fluxCapacitor.commandGateway().send(c)).toArray(CompletableFuture[]::new))));
    }

    @Override
    public When givenDomainEvents(String aggregateId, Object ... events) {
        return this.given(() -> {
            List eventList = this.flatten(events).map(e -> {
                Message m = e instanceof Message ? (Message)e : new Message(e);
                return m.withMetadata(m.getMetadata().with("$aggregateId", (Object)aggregateId));
            }).collect(Collectors.toList());
            this.fluxCapacitor.eventStore().storeDomainEvents(aggregateId, aggregateId, (long)(eventList.size() - 1), eventList);
        });
    }

    @Override
    public When givenEvents(Object ... events) {
        return this.given(() -> this.flatten(events).forEach(c -> this.fluxCapacitor.eventGateway().publish(c)));
    }

    @Override
    public When givenSchedules(Schedule ... schedules) {
        return this.given(() -> Arrays.stream(schedules).forEach(s -> this.fluxCapacitor.scheduler().schedule(s)));
    }

    @Override
    public When given(Runnable condition) {
        return (When)this.fluxCapacitor.execute(fc -> {
            try {
                condition.run();
                return this;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute given", e);
            }
        });
    }

    @Override
    public When andGiven(Runnable runnable) {
        return this.given(runnable);
    }

    @Override
    public When andGivenCommands(Object ... commands) {
        return this.givenCommands(commands);
    }

    @Override
    public When andGivenEvents(Object ... events) {
        return this.givenEvents(events);
    }

    @Override
    public When andGivenDomainEvents(String aggregateId, Object ... events) {
        return this.givenDomainEvents(aggregateId, events);
    }

    @Override
    public When andGivenSchedules(Schedule ... schedules) {
        return this.givenSchedules(schedules);
    }

    @Override
    public When andGivenExpiredSchedules(Object ... schedules) {
        return this.givenExpiredSchedules(schedules);
    }

    @Override
    public When andThenTimeAdvancesTo(Instant instant) {
        return this.given(() -> this.advanceTimeTo(instant));
    }

    @Override
    public When andThenTimeElapses(Duration duration) {
        return this.given(() -> this.advanceTimeBy(duration));
    }

    @Override
    public Then whenCommand(Object command) {
        return this.applyWhen(() -> this.getDispatchResult(this.fluxCapacitor.commandGateway().send((Object)this.interceptor.trace(command))), false);
    }

    @Override
    public Then whenQuery(Object query) {
        return this.applyWhen(() -> this.getDispatchResult(this.fluxCapacitor.queryGateway().send((Object)this.interceptor.trace(query))), false);
    }

    @Override
    public Then whenEvent(Object event) {
        return this.when(() -> this.fluxCapacitor.eventGateway().publish(this.interceptor.trace(event)), false);
    }

    @Override
    public Then whenScheduleExpires(Object schedule) {
        return this.when(() -> this.fluxCapacitor.scheduler().schedule((Object)this.interceptor.trace(schedule), this.getClock().instant()), false);
    }

    @Override
    public Then when(Runnable task) {
        return this.when(task, true);
    }

    @Override
    public Then whenApplying(Callable<?> task) {
        return this.applyWhen(task, true);
    }

    @Override
    public Then whenTimeElapses(Duration duration) {
        return this.when(() -> this.advanceTimeBy(duration), true);
    }

    @Override
    public Then whenTimeAdvancesTo(Instant instant) {
        return this.when(() -> this.advanceTimeTo(instant), true);
    }

    protected void advanceTimeBy(Duration duration) {
        this.advanceTimeTo(this.getClock().instant().plus(duration));
    }

    protected void advanceTimeTo(Instant instant) {
        this.withClock(Clock.fixed(instant, ZoneId.systemDefault()));
    }

    protected Then when(Runnable action, boolean catchAll) {
        return this.applyWhen(() -> {
            action.run();
            return null;
        }, catchAll);
    }

    protected Then applyWhen(Callable<?> action, boolean catchAll) {
        return (Then)this.fluxCapacitor.execute(fc -> {
            try {
                Object result;
                if (catchAll) {
                    this.interceptor.catchAll();
                }
                try {
                    result = action.call();
                }
                catch (Exception e) {
                    result = e;
                }
                Then then = this.createResultValidator(result);
                return then;
            }
            finally {
                this.deregisterHandlers(this.registration);
            }
        });
    }

    protected Stream<Object> flatten(Object ... messages) {
        return Arrays.stream(messages).flatMap(c -> {
            if (c instanceof Collection) {
                return ((Collection)c).stream();
            }
            if (c.getClass().isArray()) {
                return Arrays.stream((Object[])c);
            }
            return Stream.of(c);
        });
    }

    public FluxCapacitor getFluxCapacitor() {
        return this.fluxCapacitor;
    }

    protected class GivenWhenThenInterceptor
    implements DispatchInterceptor {
        private static final String TAG = "givenWhenThen.tag";
        private static final String TAG_NAME = "$givenWhenThen.tagName";
        private static final String TRACE_NAME = "$givenWhenThen.trace";
        private volatile boolean catchAll;

        protected GivenWhenThenInterceptor() {
        }

        protected void catchAll() {
            this.catchAll = true;
        }

        protected Message trace(Object message) {
            this.catchAll = false;
            Message result = message instanceof Message ? (Message)message : new Message(message, Metadata.empty());
            return result.withMetadata(result.getMetadata().with(TAG_NAME, (Object)TAG));
        }

        protected boolean isDescendantMetadata(Metadata messageMetadata) {
            return TAG.equals(messageMetadata.getOrDefault(TRACE_NAME, "").split(",")[0]);
        }

        public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function, MessageType messageType) {
            return message -> {
                Metadata metadata = message.getMetadata().addIfAbsent(TAG_NAME, UUID.randomUUID().toString());
                DeserializingMessage currentMessage = DeserializingMessage.getCurrent();
                if (currentMessage != null) {
                    metadata = currentMessage.getMetadata().containsKey(TRACE_NAME) ? metadata.with(TRACE_NAME, (Object)(currentMessage.getMetadata().get(TRACE_NAME) + "," + currentMessage.getMetadata().get(TAG_NAME))) : metadata.with(TRACE_NAME, (Object)currentMessage.getMetadata().get(TAG_NAME));
                }
                if (this.isDescendantMetadata((message = message.withMetadata(metadata)).getMetadata()) || this.catchAll) {
                    switch (messageType) {
                        case COMMAND: {
                            AbstractTestFixture.this.registerCommand((Message)message);
                            break;
                        }
                        case EVENT: {
                            AbstractTestFixture.this.registerEvent((Message)message);
                            break;
                        }
                        case SCHEDULE: {
                            AbstractTestFixture.this.registerSchedule((Schedule)message);
                        }
                    }
                }
                return (SerializedMessage)function.apply((Message)message);
            };
        }
    }
}

