/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.GivenWhenThenAssertionError;
import io.fluxcapacitor.javaclient.test.GivenWhenThenUtils;
import io.fluxcapacitor.javaclient.test.Then;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultValidator
implements Then {
    private static final Logger log = LoggerFactory.getLogger(AbstractResultValidator.class);
    private final FluxCapacitor fluxCapacitor;
    private final Object actualResult;

    @Override
    public AbstractResultValidator expectResult(Object expectedResult) {
        return (AbstractResultValidator)this.fluxCapacitor.execute(fc -> {
            if (this.actualResult instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.actualResult);
            }
            if (!this.matches(expectedResult, this.actualResult)) {
                if (!(expectedResult instanceof Matcher) && this.actualResult != null && expectedResult != null && !Objects.equals(expectedResult.getClass(), this.actualResult.getClass())) {
                    throw new GivenWhenThenAssertionError(String.format("Handler returned a result of unexpected type.\nExpected: %s\nGot: %s", expectedResult.getClass(), this.actualResult.getClass()));
                }
                throw new GivenWhenThenAssertionError("Handler returned an unexpected result", expectedResult, this.actualResult);
            }
            return this;
        });
    }

    @Override
    public AbstractResultValidator expectNoResultLike(Object value) {
        return (AbstractResultValidator)this.fluxCapacitor.execute(fc -> {
            if (this.actualResult instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.actualResult);
            }
            if (this.matches(value, this.actualResult)) {
                throw new GivenWhenThenAssertionError(String.format("Handler returned the unwanted result.\nExpected not to get: %s\nGot: %s", value, this.actualResult));
            }
            return this;
        });
    }

    @Override
    public AbstractResultValidator verify(Runnable check) {
        return (AbstractResultValidator)this.fluxCapacitor.execute(fc -> {
            try {
                check.run();
            }
            catch (Exception e) {
                throw new GivenWhenThenAssertionError("Verify check failed", e);
            }
            return this;
        });
    }

    @Override
    public AbstractResultValidator expectException(Matcher<?> resultMatcher) {
        return (AbstractResultValidator)this.fluxCapacitor.execute(fc -> {
            StringDescription description = new StringDescription();
            resultMatcher.describeTo((Description)description);
            if (!(this.actualResult instanceof Throwable)) {
                throw new GivenWhenThenAssertionError("Handler returned normally but an exception was expected", description, this.actualResult);
            }
            if (!resultMatcher.matches(this.actualResult)) {
                throw new GivenWhenThenAssertionError("Handler threw unexpected exception", description, this.actualResult);
            }
            return this;
        });
    }

    protected AbstractResultValidator expectScheduledMessages(Collection<?> expected, Collection<? extends Schedule> actual) {
        return (AbstractResultValidator)this.fluxCapacitor.execute(fc -> {
            if (!expected.isEmpty() && actual.isEmpty()) {
                throw new GivenWhenThenAssertionError("No messages were scheduled");
            }
            expected.forEach(e -> {
                if (e instanceof Schedule && actual.stream().noneMatch(s -> Objects.equals(s.getDeadline(), ((Schedule)e).getDeadline()))) {
                    throw new GivenWhenThenAssertionError(String.format("Found no schedules with matching deadline. Expected %s. Got %s", ((Schedule)e).getDeadline(), actual.stream().map(Schedule::getDeadline).collect(Collectors.toList())));
                }
            });
            return this.expectMessages(this.asMessages(expected), actual);
        });
    }

    protected void reportMismatch(Collection<?> expected, Collection<? extends Message> actual) {
        this.fluxCapacitor.execute(fc -> {
            if (this.actualResult instanceof Throwable) {
                throw new GivenWhenThenAssertionError("Published messages did not match. Probable cause is an exception that occurred during handling:", (Throwable)this.actualResult);
            }
            throw new GivenWhenThenAssertionError("Published messages did not match", expected, actual);
        });
    }

    protected void reportUnwantedMatch(Collection<?> expected, Collection<? extends Message> actual) {
        this.fluxCapacitor.execute(fc -> {
            if (this.actualResult instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.actualResult);
            }
            throw new GivenWhenThenAssertionError(String.format("Unwanted match found in published messages.\nExpected not to get: %s\nGot: %s\n\n", expected, actual));
        });
    }

    protected AbstractResultValidator expectMessages(Collection<?> expected, Collection<? extends Message> actual) {
        if (!this.containsAll(expected, actual)) {
            ArrayList<? extends Message> remaining = new ArrayList<Message>(actual);
            List filtered = expected.stream().flatMap(e -> {
                if (e != null && !(expected instanceof Matcher) && !(expected instanceof Predicate)) {
                    Class<?> payloadType = e instanceof Message ? ((Message)e).getPayload().getClass() : expected.getClass();
                    Message match = remaining.stream().filter(a -> payloadType.equals(a.getPayload().getClass())).findFirst().orElse(null);
                    if (match != null) {
                        remaining.remove(match);
                        return Stream.of(match);
                    }
                }
                return Stream.empty();
            }).collect(Collectors.toList());
            this.reportMismatch(expected, filtered.size() == expected.size() ? filtered : actual);
        }
        return this;
    }

    protected AbstractResultValidator expectOnlyMessages(Collection<?> expected, Collection<? extends Message> actual) {
        if (expected.size() != actual.size()) {
            this.reportMismatch(expected, actual);
        } else if (!this.containsAll(expected, actual)) {
            this.reportMismatch(expected, actual);
        }
        return this;
    }

    protected AbstractResultValidator expectNoMessagesLike(Collection<?> expectedNotToGet, Collection<? extends Message> actual) {
        if (this.containsAny(expectedNotToGet, actual)) {
            this.reportUnwantedMatch(expectedNotToGet, actual);
        }
        return this;
    }

    protected AbstractResultValidator expectOnlyScheduledMessages(Collection<?> expected, Collection<? extends Schedule> actual) {
        AbstractResultValidator result = this.expectScheduledMessages(expected, actual);
        return result.expectOnlyMessages(expected, actual);
    }

    protected boolean containsAll(Collection<?> expected, Collection<? extends Message> actual) {
        return expected.stream().allMatch(e -> actual.stream().anyMatch(a -> this.matches(e, (Message)a)));
    }

    protected boolean containsAny(Collection<?> expected, Collection<? extends Message> actual) {
        return expected.stream().anyMatch(e -> actual.stream().anyMatch(a -> this.matches(e, (Message)a)));
    }

    protected boolean matches(Object expected, Object actual) {
        if (actual instanceof Message) {
            return this.matches((Object)expected, (Message)actual);
        }
        if (expected instanceof Predicate) {
            expected = GivenWhenThenUtils.toMatcher((Predicate)expected);
        }
        if (expected instanceof Matcher) {
            return expected.matches(actual);
        }
        return Objects.equals(expected, actual);
    }

    protected boolean matches(Object expected, Message actual) {
        if (expected instanceof Predicate) {
            expected = GivenWhenThenUtils.toMatcher((Predicate)expected);
        }
        if (expected instanceof Matcher) {
            return expected.matches(actual.getPayload()) || expected.matches((Object)actual);
        }
        Message expectedMessage = (Message)expected;
        return expectedMessage.getPayload().equals(actual.getPayload()) && actual.getMetadata().entrySet().containsAll(expectedMessage.getMetadata().entrySet());
    }

    protected Collection<?> asMessages(Collection<?> expectedMessages) {
        return expectedMessages.stream().map(e -> e instanceof Predicate ? GivenWhenThenUtils.toMatcher((Predicate)e) : (e instanceof Matcher ? (Matcher)e : (e instanceof Message ? (Message)e : new Message(e)))).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"fluxCapacitor", "actualResult"})
    public AbstractResultValidator(FluxCapacitor fluxCapacitor, Object actualResult) {
        this.fluxCapacitor = fluxCapacitor;
        this.actualResult = actualResult;
    }

    protected FluxCapacitor getFluxCapacitor() {
        return this.fluxCapacitor;
    }
}

