/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.benchmark;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.benchmark.AbstractClientBenchmark;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import java.time.Clock;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelJavaClientRunner
extends AbstractClientBenchmark {
    private static final Logger log = LoggerFactory.getLogger(LowLevelJavaClientRunner.class);
    private final Client client = WebSocketClient.newInstance((WebSocketClient.Properties)this.getClientProperties());

    public static void main(String[] args) {
        LowLevelJavaClientRunner runner = new LowLevelJavaClientRunner(100000);
        runner.testCommands();
        System.exit(0);
    }

    public LowLevelJavaClientRunner(int commandCount) {
        super(commandCount);
        DefaultTracker.start(this::handleCommands, (ConsumerConfiguration)ConsumerConfiguration.getDefault((MessageType)MessageType.COMMAND).toBuilder().prependApplicationName(false).name("javaClientRunner/command").build(), (Client)this.client);
        CountDownLatch commandsSentCountdown = new CountDownLatch(commandCount);
        this.commandGateway().registerMonitor(m -> {
            commandsSentCountdown.countDown();
            if (commandsSentCountdown.getCount() == 0L) {
                log.info("Finished sending {} commands", (Object)commandCount);
            }
        });
    }

    @Override
    protected void doSendCommand(String payload) {
        this.commandGateway().send(new SerializedMessage[]{new SerializedMessage(new Data((Object)payload.getBytes(), String.class.getName(), 0), Metadata.empty(), UUID.randomUUID().toString(), Long.valueOf(Clock.systemUTC().millis()))});
    }

    protected GatewayClient commandGateway() {
        return this.client.getGatewayClient(MessageType.COMMAND);
    }

    private void handleCommands(List<SerializedMessage> commands) {
        commands.forEach(m -> {
            try {
                this.getCommandCountDownLatch().countDown();
            }
            catch (Exception e) {
                log.error("Failed to handle command", (Throwable)e);
                throw new IllegalStateException("Failed to handle command", e);
            }
        });
    }
}

