/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.authentication;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;

public class AuthenticatingInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    private final UserProvider userProvider;

    @Override
    public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function, MessageType messageType) {
        return m -> {
            if (!this.userProvider.containsUser(m.getMetadata())) {
                User user = this.userProvider.getActiveUser();
                if (user == null) {
                    user = Optional.ofNullable(DeserializingMessage.getCurrent()).map(d -> this.userProvider.getSystemUser()).orElse(null);
                }
                if (user != null) {
                    m = m.withMetadata(this.userProvider.addToMetadata(m.getMetadata(), user));
                }
            }
            return (SerializedMessage)function.apply((Message)m);
        };
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return m -> {
            Object previous = User.getCurrent();
            User user = this.userProvider.fromMetadata(m.getMetadata());
            try {
                User.current.set(user);
                ValidationUtils.assertAuthorized(m.getPayloadClass(), user);
                Object r = function.apply((DeserializingMessage)m);
                return r;
            }
            finally {
                User.current.set((User)previous);
            }
        };
    }

    @ConstructorProperties(value={"userProvider"})
    public AuthenticatingInterceptor(UserProvider userProvider) {
        this.userProvider = userProvider;
    }
}

