/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.function.Function;

@FunctionalInterface
public interface HandlerInterceptor {
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> var1, Handler<DeserializingMessage> var2, String var3);

    default public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
        return new InterceptedHandler(handler, this, consumer);
    }

    default public HandlerInterceptor merge(HandlerInterceptor nextInterceptor) {
        return new MergedInterceptor(this, nextInterceptor);
    }

    public static class InterceptedHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;
        private final HandlerInterceptor interceptor;
        private final String consumer;

        public Object invoke(DeserializingMessage message) {
            return this.interceptor.interceptHandling(arg_0 -> this.delegate.invoke(arg_0), this.delegate, this.consumer).apply(message);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate", "interceptor", "consumer"})
        public InterceptedHandler(Handler<DeserializingMessage> delegate, HandlerInterceptor interceptor, String consumer) {
            this.delegate = delegate;
            this.interceptor = interceptor;
            this.consumer = consumer;
        }

        public boolean canHandle(DeserializingMessage arg0) {
            return this.delegate.canHandle((Object)arg0);
        }

        public Executable getMethod(DeserializingMessage arg0) {
            return this.delegate.getMethod((Object)arg0);
        }

        public boolean isPassive(DeserializingMessage arg0) {
            return this.delegate.isPassive((Object)arg0);
        }

        public Object getTarget() {
            return this.delegate.getTarget();
        }

        private static interface ExcludedMethods {
            public Object invoke(DeserializingMessage var1);
        }
    }

    public static class MergedInterceptor
    implements HandlerInterceptor {
        private final HandlerInterceptor first;
        private final HandlerInterceptor second;

        @Override
        public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
            return this.first.interceptHandling(this.second.interceptHandling(function, handler, consumer), handler, consumer);
        }

        @Override
        public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
            this.second.wrap(handler, consumer);
            this.first.wrap(handler, consumer);
            return HandlerInterceptor.super.wrap(handler, consumer);
        }

        @ConstructorProperties(value={"first", "second"})
        public MergedInterceptor(HandlerInterceptor first, HandlerInterceptor second) {
            this.first = first;
            this.second = second;
        }
    }
}

