/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.Timeout;
import io.fluxcapacitor.javaclient.publishing.TimeoutException;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public interface GenericGateway
extends HasLocalHandlers {
    default public void sendAndForget(Object payload) {
        this.sendAndForget(payload instanceof Message ? (Message)payload : new Message(payload));
    }

    default public void sendAndForget(Object payload, Metadata metadata) {
        this.sendAndForget(new Message(payload, metadata));
    }

    public void sendAndForget(Message var1);

    default public <R> CompletableFuture<R> send(Message message) {
        return this.sendForMessage(message).thenApply(Message::getPayload);
    }

    default public <R> CompletableFuture<R> send(Object payload) {
        return this.send(payload instanceof Message ? (Message)payload : new Message(payload));
    }

    default public <R> CompletableFuture<R> send(Object payload, Metadata metadata) {
        return this.send(new Message(payload, metadata));
    }

    public CompletableFuture<Message> sendForMessage(Message var1);

    default public <R> R sendAndWait(Object payload) {
        return this.sendAndWait(payload instanceof Message ? (Message)payload : new Message(payload));
    }

    default public <R> R sendAndWait(Object payload, Metadata metadata) {
        return this.sendAndWait(new Message(payload, metadata));
    }

    default public <R> R sendAndWait(Message message) {
        CompletableFuture<R> future = this.send(message);
        try {
            Timeout timeout = message.getPayload().getClass().getAnnotation(Timeout.class);
            if (timeout != null) {
                return future.get(timeout.millis(), TimeUnit.MILLISECONDS);
            }
            return future.get(1L, TimeUnit.MINUTES);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("%s has timed out", message.getPayload().toString()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GatewayException(String.format("Thread interrupted while waiting for result of %s", message.getPayload().toString()), e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

