/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class DefaultGenericGateway
implements GenericGateway {
    private final GatewayClient gatewayClient;
    private final RequestHandler requestHandler;
    private final MessageSerializer serializer;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void sendAndForget(Message message) {
        block7: {
            SerializedMessage serializedMessage = this.serializer.serialize(message);
            Optional<CompletableFuture<Message>> localResult = this.localHandlerRegistry.handle(message.getPayload(), serializedMessage);
            if (!localResult.isPresent()) {
                try {
                    this.gatewayClient.send(serializedMessage);
                    break block7;
                }
                catch (Exception e) {
                    throw new GatewayException(String.format("Failed to send and forget %s", message.getPayload().toString()), e);
                }
            }
            if (!localResult.get().isCompletedExceptionally()) break block7;
            try {
                localResult.get().getNow(null);
            }
            catch (CompletionException e) {
                throw e.getCause();
            }
        }
    }

    @Override
    public CompletableFuture<Message> sendForMessage(Message message) {
        SerializedMessage serializedMessage = this.serializer.serialize(message);
        Optional<CompletableFuture<Message>> localResult = this.localHandlerRegistry.handle(message.getPayload(), serializedMessage);
        if (localResult.isPresent()) {
            return localResult.get();
        }
        try {
            return this.requestHandler.sendRequest(serializedMessage, xva$0 -> this.gatewayClient.send((SerializedMessage)xva$0));
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send %s", message.getPayload().toString()), e);
        }
    }

    @ConstructorProperties(value={"gatewayClient", "requestHandler", "serializer", "localHandlerRegistry"})
    public DefaultGenericGateway(GatewayClient gatewayClient, RequestHandler requestHandler, MessageSerializer serializer, HandlerRegistry localHandlerRegistry) {
        this.gatewayClient = gatewayClient;
        this.requestHandler = requestHandler;
        this.serializer = serializer;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        return this.localHandlerRegistry.handle(payload, serializedMessage);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, HandlerConfiguration<DeserializingMessage> handlerConfiguration) {
        return this.localHandlerRegistry.registerHandler(target, handlerConfiguration);
    }
}

