/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InMemorySearchClient
implements SearchClient {
    private final List<Document> documents = new CopyOnWriteArrayList<Document>();

    @Override
    public Awaitable index(List<Document> documents, Guarantee guarantee) {
        this.documents.addAll(documents);
        return Awaitable.ready();
    }

    @Override
    public Stream<SearchHit<Document>> search(SearchDocuments searchDocuments) {
        SearchQuery query = searchDocuments.getQuery();
        Stream<Document> documentStream = this.documents.stream().filter(arg_0 -> ((SearchQuery)query).matches(arg_0));
        if (searchDocuments.getMaxSize() != null) {
            documentStream = documentStream.limit(searchDocuments.getMaxSize().intValue());
        }
        documentStream = documentStream.sorted(this.createComparator(searchDocuments.getSorting()));
        if (!searchDocuments.getPathFilters().isEmpty()) {
            Predicate pathFilter = searchDocuments.computePathFilter();
            documentStream = documentStream.map(d -> d.filterPaths(pathFilter));
        }
        return documentStream.map(d -> new SearchHit<Document>(d.getId(), d.getCollection(), d.getTimestamp(), () -> d));
    }

    @Override
    public Awaitable delete(SearchQuery query, Guarantee guarantee) {
        this.documents.removeAll(this.documents.stream().filter(arg_0 -> ((SearchQuery)query).matches(arg_0)).collect(Collectors.toList()));
        return Awaitable.ready();
    }

    @Override
    public Awaitable delete(String collection, String documentId, Guarantee guarantee) {
        this.documents.removeIf(d -> Objects.equals(documentId, d.getId()) && Objects.equals(collection, d.getCollection()));
        return Awaitable.ready();
    }

    @Override
    public Awaitable createAuditTrail(CreateAuditTrail request) {
        return Awaitable.ready();
    }

    @Override
    public Awaitable deleteCollection(String collection) {
        this.documents.removeIf(d -> Objects.equals(collection, d.getCollection()));
        return Awaitable.ready();
    }

    @Override
    public List<DocumentStats> getStatistics(SearchQuery query, List<String> fields, List<String> groupBy) {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        Map<List, List<Document>> groups = this.documents.stream().filter(arg_0 -> ((SearchQuery)query).matches(arg_0)).collect(Collectors.groupingBy(d -> groupBy.stream().map(g -> d.getEntryAtPath(g).map(Document.Entry::getValue).orElse(null)).collect(Collectors.toList())));
        return groups.entrySet().stream().map(e -> new DocumentStats(fields.stream().collect(Collectors.toMap(Function.identity(), f -> this.getFieldStats((String)f, (List)e.getValue()), (a, b) -> b)), this.asMap(groupBy, (List)e.getKey()))).collect(Collectors.toList());
    }

    @Override
    public SearchHistogram getHistogram(GetSearchHistogram request) {
        SearchQuery query = request.getQuery();
        List results = IntStream.range(0, request.getResolution()).mapToLong(i -> 0L).boxed().collect(Collectors.toList());
        if (query.getSince() == null) {
            return new SearchHistogram(query.getSince(), query.getBefore(), results);
        }
        if (query.getBefore() == null) {
            query = query.toBuilder().before(Instant.now()).build();
        }
        long min = query.getSince().toEpochMilli();
        long delta = query.getBefore().toEpochMilli() - min;
        long step = Math.min(1L, delta / (long)request.getResolution());
        this.search(SearchDocuments.builder().query(query).build()).collect(Collectors.groupingBy(d -> (d.getTimestamp().toEpochMilli() - min) / step)).forEach((bucket, hits) -> results.set(bucket.intValue(), Long.valueOf(hits.size())));
        return new SearchHistogram(query.getSince(), query.getBefore(), results);
    }

    private DocumentStats.FieldStats getFieldStats(String path, List<Document> documents) {
        DocumentStats.FieldStats.FieldStatsBuilder builder = DocumentStats.FieldStats.builder().count((long)documents.size());
        List values = documents.stream().flatMap(d -> d.getEntryAtPath(path).map(Stream::of).orElseGet(Stream::empty)).filter(e -> e.getType() == Document.EntryType.NUMERIC).map(e -> new BigDecimal(e.getValue())).sorted().collect(Collectors.toList());
        if (!values.isEmpty()) {
            builder.min((BigDecimal)values.get(0));
            builder.max((BigDecimal)values.get(values.size() - 1));
            builder.average(DocumentStats.FieldStats.getAverage(values));
        }
        return builder.build();
    }

    private Map<String, String> asMap(List<String> groupBy, List<String> values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < groupBy.size(); ++i) {
            result.put(groupBy.get(i), values.get(i));
        }
        return result;
    }

    private Comparator<Document> createComparator(List<String> sorting) {
        return sorting.stream().map(s -> {
            switch (s) {
                case "-timestamp": {
                    return Comparator.comparing(Document::getTimestamp).reversed();
                }
                case "timestamp": {
                    return Comparator.comparing(Document::getTimestamp);
                }
            }
            boolean reversed = s.startsWith("-");
            String path = reversed ? s.substring(1) : s;
            Comparator<Document> valueComparator = Comparator.nullsLast(Comparator.comparing(d -> d.getEntryAtPath(path).orElse(null)));
            return reversed ? valueComparator.reversed() : valueComparator;
        }).reduce(Comparator::thenComparing).orElse(Comparator.comparing(Document::getTimestamp).reversed());
    }

    @Override
    public void close() {
    }
}

