/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.Search;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface DocumentStore {
    default public void index(Object object, String collection) {
        this.index(object, FluxCapacitor.currentIdentityProvider().nextId(), collection);
    }

    default public void index(Object object, String id, String collection) {
        this.index(object, id, collection, null);
    }

    default public void index(Object object, String id, String collection, Instant timestamp) {
        this.index(object, id, collection, timestamp, null, Guarantee.STORED).get();
    }

    default public void index(Object object, String id, String collection, Instant timestamp, Instant end) {
        this.index(object, id, collection, timestamp, end, Guarantee.STORED).get();
    }

    public CompletableFuture<Void> index(Object var1, String var2, String var3, Instant var4, Instant var5, Guarantee var6);

    default public <T> void index(Collection<? extends T> objects, String collection) {
        this.index(objects, collection, (? super T v) -> FluxCapacitor.currentIdentityProvider().nextId());
    }

    default public <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction) {
        this.index(objects, collection, idFunction, (? super T v) -> null);
    }

    default public <T> void index(Collection<? extends T> objects, String collection, @Nullable String idPath, @Nullable String timestampPath) {
        this.index(objects, collection, idPath, timestampPath, null, Guarantee.STORED).get();
    }

    default public <T> void index(Collection<? extends T> objects, String collection, @Nullable String idPath, @Nullable String timestampPath, @Nullable String endPath) {
        this.index(objects, collection, idPath, timestampPath, endPath, Guarantee.STORED).get();
    }

    public <T> CompletableFuture<Void> index(Collection<? extends T> var1, String var2, @Nullable String var3, @Nullable String var4, @Nullable String var5, Guarantee var6);

    default public <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> timestampFunction) {
        this.index(objects, collection, idFunction, timestampFunction, (? super T t) -> null, Guarantee.STORED).get();
    }

    default public <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> timestampFunction, Function<? super T, Instant> endFunction) {
        this.index(objects, collection, idFunction, timestampFunction, endFunction, Guarantee.STORED).get();
    }

    public <T> CompletableFuture<Void> index(Collection<? extends T> var1, String var2, Function<? super T, String> var3, Function<? super T, Instant> var4, Function<? super T, Instant> var5, Guarantee var6);

    default public Search search(String ... collections) {
        return this.search(SearchQuery.builder().collections(Arrays.asList(collections)));
    }

    public Search search(SearchQuery.Builder var1);

    public void deleteDocument(String var1, String var2);

    public void deleteCollection(String var1);

    public void createAuditTrail(String var1, Duration var2);

    public DocumentSerializer getSerializer();
}

