/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import java.beans.ConstructorProperties;
import java.time.Instant;

public final class EventSourcedModel<T>
implements AggregateRoot<T> {
    private final String id;
    private final Class<T> type;
    private final long sequenceNumber;
    private final String lastEventId;
    private final Instant timestamp;
    private final T model;
    private final EventSourcedModel<T> previous;

    @Override
    public T get() {
        return this.model;
    }

    @Override
    public AggregateRoot<T> apply(Message eventMessage) {
        throw new UnsupportedOperationException(String.format("Not allowed to apply a %s. The model is readonly.", eventMessage));
    }

    private static <T> long $default$sequenceNumber() {
        return -1L;
    }

    private static <T> Instant $default$timestamp() {
        return Instant.now();
    }

    @ConstructorProperties(value={"id", "type", "sequenceNumber", "lastEventId", "timestamp", "model", "previous"})
    EventSourcedModel(String id, Class<T> type, long sequenceNumber, String lastEventId, Instant timestamp, T model, EventSourcedModel<T> previous) {
        this.id = id;
        this.type = type;
        this.sequenceNumber = sequenceNumber;
        this.lastEventId = lastEventId;
        this.timestamp = timestamp;
        this.model = model;
        this.previous = previous;
    }

    public static <T> EventSourcedModelBuilder<T> builder() {
        return new EventSourcedModelBuilder();
    }

    public EventSourcedModelBuilder<T> toBuilder() {
        return new EventSourcedModelBuilder().id(this.id).type(this.type).sequenceNumber(this.sequenceNumber).lastEventId(this.lastEventId).timestamp(this.timestamp).model(this.model).previous(this.previous);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String lastEventId() {
        return this.lastEventId;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    public T model() {
        return this.model;
    }

    @Override
    public EventSourcedModel<T> previous() {
        return this.previous;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventSourcedModel)) {
            return false;
        }
        EventSourcedModel other = (EventSourcedModel)o;
        if (this.sequenceNumber() != other.sequenceNumber()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<T> this$type = this.type();
        Class<T> other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$lastEventId = this.lastEventId();
        String other$lastEventId = other.lastEventId();
        if (this$lastEventId == null ? other$lastEventId != null : !this$lastEventId.equals(other$lastEventId)) {
            return false;
        }
        Instant this$timestamp = this.timestamp();
        Instant other$timestamp = other.timestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        T this$model = this.model();
        T other$model = other.model();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        AggregateRoot this$previous = this.previous();
        AggregateRoot other$previous = other.previous();
        return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.sequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Class<T> $type = this.type();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $lastEventId = this.lastEventId();
        result = result * 59 + ($lastEventId == null ? 43 : $lastEventId.hashCode());
        Instant $timestamp = this.timestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        T $model = this.model();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        AggregateRoot $previous = this.previous();
        result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
        return result;
    }

    public String toString() {
        return "EventSourcedModel(id=" + this.id() + ", type=" + this.type() + ", sequenceNumber=" + this.sequenceNumber() + ", lastEventId=" + this.lastEventId() + ", timestamp=" + this.timestamp() + ", model=" + this.model() + ", previous=" + this.previous() + ")";
    }

    public static class EventSourcedModelBuilder<T> {
        private String id;
        private Class<T> type;
        private boolean sequenceNumber$set;
        private long sequenceNumber$value;
        private String lastEventId;
        private boolean timestamp$set;
        private Instant timestamp$value;
        private T model;
        private EventSourcedModel<T> previous;

        EventSourcedModelBuilder() {
        }

        public EventSourcedModelBuilder<T> id(String id) {
            this.id = id;
            return this;
        }

        public EventSourcedModelBuilder<T> type(Class<T> type) {
            this.type = type;
            return this;
        }

        public EventSourcedModelBuilder<T> sequenceNumber(long sequenceNumber) {
            this.sequenceNumber$value = sequenceNumber;
            this.sequenceNumber$set = true;
            return this;
        }

        public EventSourcedModelBuilder<T> lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public EventSourcedModelBuilder<T> timestamp(Instant timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        public EventSourcedModelBuilder<T> model(T model) {
            this.model = model;
            return this;
        }

        public EventSourcedModelBuilder<T> previous(EventSourcedModel<T> previous) {
            this.previous = previous;
            return this;
        }

        public EventSourcedModel<T> build() {
            long sequenceNumber$value = this.sequenceNumber$value;
            if (!this.sequenceNumber$set) {
                sequenceNumber$value = EventSourcedModel.$default$sequenceNumber();
            }
            Instant timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = EventSourcedModel.$default$timestamp();
            }
            return new EventSourcedModel<T>(this.id, this.type, sequenceNumber$value, this.lastEventId, timestamp$value, this.model, this.previous);
        }

        public String toString() {
            return "EventSourcedModel.EventSourcedModelBuilder(id=" + this.id + ", type=" + this.type + ", sequenceNumber$value=" + this.sequenceNumber$value + ", lastEventId=" + this.lastEventId + ", timestamp$value=" + this.timestamp$value + ", model=" + this.model + ", previous=" + this.previous + ")";
        }
    }
}

