/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerNotFoundException;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.Apply;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.ApplyEvent;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class AnnotatedEventSourcingHandler<T>
implements EventSourcingHandler<T> {
    private final ThreadLocal<T> currentAggregate = new ThreadLocal();
    private final Class<T> handlerType;
    private final HandlerInvoker<DeserializingMessage> aggregateInvoker;
    private final Function<Class<?>, HandlerInvoker<DeserializingMessage>> eventInvokers;

    public AnnotatedEventSourcingHandler(Class<T> handlerType) {
        this(handlerType, DeserializingMessage.defaultParameterResolvers);
    }

    public AnnotatedEventSourcingHandler(Class<T> handlerType, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.handlerType = handlerType;
        this.aggregateInvoker = HandlerInspector.inspect(handlerType, ApplyEvent.class, parameterResolvers, (HandlerConfiguration)HandlerConfiguration.defaultHandlerConfiguration());
        this.eventInvokers = ObjectUtils.memoize(eventType -> {
            ArrayList<ParameterResolver> paramResolvers = new ArrayList<ParameterResolver>(parameterResolvers);
            paramResolvers.add(0, p -> p.getType().isAssignableFrom(handlerType) ? event -> this.currentAggregate.get() : null);
            return HandlerInspector.inspect((Class)eventType, Apply.class, paramResolvers, (HandlerConfiguration)HandlerConfiguration.defaultHandlerConfiguration());
        });
    }

    @Override
    public T invoke(T target, DeserializingMessage message) {
        return (T)message.apply(m -> {
            Object result;
            HandlerInvoker<DeserializingMessage> invoker;
            try {
                this.currentAggregate.set(target);
                boolean handledByAggregate = this.aggregateInvoker.canHandle(target, m);
                invoker = handledByAggregate ? this.aggregateInvoker : this.eventInvokers.apply(message.getPayloadClass());
                result = invoker.invoke(handledByAggregate ? target : m.getPayload(), m);
            }
            catch (HandlerNotFoundException e) {
                if (target == null) {
                    throw e;
                }
                Object object = target;
                return object;
            }
            finally {
                this.currentAggregate.remove();
            }
            if (target == null) {
                return this.handlerType.cast(result);
            }
            if (this.handlerType.isInstance(result)) {
                return this.handlerType.cast(result);
            }
            if (result == null && invoker.expectResult(target, m)) {
                return null;
            }
            return target;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canHandle(T target, DeserializingMessage message) {
        try {
            this.currentAggregate.set(target);
            boolean bl = this.aggregateInvoker.canHandle(target, (Object)message) || this.eventInvokers.apply(message.getPayloadClass()).canHandle(message.getPayload(), (Object)message);
            return bl;
        }
        finally {
            this.currentAggregate.remove();
        }
    }
}

