/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.RetryConfiguration;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.QueryResult;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.websocket.SessionPool;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import java.beans.ConstructorProperties;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DecodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebsocketClient.class);
    public static WebSocketContainer defaultWebSocketContainer = ContainerProvider.getWebSocketContainer();
    public static ObjectMapper defaultObjectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();
    private final SessionPool sessionPool;
    private final WebSocketClient.Properties properties;
    private final ObjectMapper objectMapper;
    private final Map<Long, WebSocketRequest> requests = new ConcurrentHashMap<Long, WebSocketRequest>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final boolean sendMetrics;

    public AbstractWebsocketClient(URI endpointUri, WebSocketClient.Properties properties, boolean sendMetrics) {
        this(endpointUri, properties, sendMetrics, 1);
    }

    public AbstractWebsocketClient(URI endpointUri, WebSocketClient.Properties properties, boolean sendMetrics, int numberOfSessions) {
        this(defaultWebSocketContainer, endpointUri, properties, sendMetrics, Duration.ofSeconds(1L), defaultObjectMapper, numberOfSessions);
    }

    public AbstractWebsocketClient(WebSocketContainer container, URI endpointUri, WebSocketClient.Properties properties, boolean sendMetrics, Duration reconnectDelay, ObjectMapper objectMapper, int numberOfSessions) {
        this.properties = properties;
        this.objectMapper = objectMapper;
        this.sendMetrics = sendMetrics;
        this.sessionPool = new SessionPool(numberOfSessions, () -> (Session)TimingUtils.retryOnFailure(() -> container.connectToServer((Object)this, endpointUri), (RetryConfiguration)RetryConfiguration.builder().delay(reconnectDelay).errorTest(e -> !this.closed.get()).successLogger(s -> log.info("Successfully reconnected to endpoint {}", (Object)endpointUri)).exceptionLogger(status -> {
            if (status.getNumberOfTimesRetried() == 0) {
                log.warn("Failed to connect to endpoint {}; reason: {}. Retrying every {} ms...", new Object[]{endpointUri, status.getException().getMessage(), status.getRetryConfiguration().getDelay().toMillis()});
            }
        }).build()));
    }

    protected <R extends QueryResult> CompletableFuture<R> send(Request request) {
        return new WebSocketRequest(request, FluxCapacitor.currentCorrelationData()).send();
    }

    protected <R extends QueryResult> R sendAndWait(Request request) {
        return (R)((QueryResult)this.send(request).get());
    }

    protected Awaitable sendAndForget(JsonType object) {
        Awaitable awaitable = this.doSend(object, this.sessionPool.get());
        this.tryPublishMetrics(object.toMetric(), Metadata.empty());
        return awaitable;
    }

    protected Awaitable doSend(JsonType object, Session session) {
        try (OutputStream outputStream = session.getBasicRemote().getSendStream();){
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)object);
            outputStream.write(CompressionUtils.compress((byte[])bytes, (CompressionAlgorithm)this.properties.getCompression()));
        }
        catch (Exception e) {
            log.error("Failed to send request {}", (Object)object, (Object)e);
            throw e;
        }
        return Awaitable.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(byte[] bytes) {
        block8: {
            JsonType value;
            try {
                value = (JsonType)this.objectMapper.readValue(CompressionUtils.decompress((byte[])bytes, (CompressionAlgorithm)this.properties.getCompression()), JsonType.class);
            }
            catch (Exception e) {
                throw new DecodeException("", "Could not parse input. Expected a Json message.", (Throwable)e);
            }
            QueryResult readResult = (QueryResult)value;
            WebSocketRequest webSocketRequest = this.requests.remove(readResult.getRequestId());
            if (webSocketRequest == null) {
                log.warn("Could not find outstanding read request for id {}", (Object)readResult.getRequestId());
                break block8;
            }
            try {
                this.tryPublishMetrics(readResult.toMetric(), Metadata.of((Object[])new Object[]{"requestId", webSocketRequest.request.getRequestId(), "msDuration", System.currentTimeMillis() - webSocketRequest.sendTimestamp}).with(webSocketRequest.correlationData));
            }
            finally {
                webSocketRequest.result.complete(readResult);
            }
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        if (closeReason.getCloseCode().getCode() > CloseReason.CloseCodes.NO_STATUS_CODE.getCode()) {
            log.warn("Connection to endpoint {} closed with reason {}", (Object)session.getRequestURI(), (Object)closeReason);
        }
        this.retryOutstandingRequests(session.getId());
    }

    protected void retryOutstandingRequests(String sessionId) {
        if (!this.closed.get() && !this.requests.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted while trying to retry outstanding requests", e);
            }
            this.requests.values().stream().filter(r -> sessionId.equals(((WebSocketRequest)r).sessionId)).forEach(WebSocketRequest::send);
        }
    }

    @OnError
    public void onError(Session session, Throwable e) {
        log.error("Client side error for web socket connected to endpoint {}", (Object)session.getRequestURI(), (Object)e);
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean clearOutstandingRequests) {
        if (this.closed.compareAndSet(false, true)) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (clearOutstandingRequests) {
                    this.requests.clear();
                }
                this.sessionPool.close();
                if (!this.requests.isEmpty()) {
                    log.warn("{}: Closed websocket session to endpoint with {} outstanding requests", (Object)this.getClass().getSimpleName(), (Object)this.requests.size());
                }
            }
        }
    }

    protected void tryPublishMetrics(Object metric, Metadata metadata) {
        if (this.sendMetrics && metric != null) {
            FluxCapacitor.getOptionally().ifPresent(f -> FluxCapacitor.publishMetrics(metric, metadata));
        }
    }

    protected class WebSocketRequest {
        private final Request request;
        private final CompletableFuture<QueryResult> result = new CompletableFuture();
        private final Map<String, String> correlationData;
        private volatile String sessionId;
        private volatile long sendTimestamp;

        protected <T extends QueryResult> CompletableFuture<T> send() {
            Session session;
            try {
                session = AbstractWebsocketClient.this.sessionPool.get();
            }
            catch (Exception e) {
                log.error("Failed to get websocket session to send request {}", (Object)this.request, (Object)e);
                this.result.completeExceptionally(e);
                return this.result;
            }
            this.sessionId = session.getId();
            AbstractWebsocketClient.this.requests.put(this.request.getRequestId(), this);
            try {
                this.sendTimestamp = System.currentTimeMillis();
                AbstractWebsocketClient.this.doSend((JsonType)this.request, session);
                AbstractWebsocketClient.this.tryPublishMetrics(this.request.toMetric(), Metadata.of((String)"requestId", (Object)this.request.getRequestId()));
            }
            catch (Exception e) {
                AbstractWebsocketClient.this.requests.remove(this.request.getRequestId());
                this.result.completeExceptionally(e);
            }
            return this.result;
        }

        @ConstructorProperties(value={"request", "correlationData"})
        public WebSocketRequest(Request request, Map<String, String> correlationData) {
            this.request = request;
            this.correlationData = correlationData;
        }
    }
}

