/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.SerializedObject;
import java.util.function.Function;

public class DeserializingObject<T, S extends SerializedObject<T, S>> {
    private final S serializedObject;
    private final ObjectUtils.MemoizingFunction<Class<?>, Object> object;

    public DeserializingObject(S serializedObject, Function<Class<?>, Object> payload) {
        this.serializedObject = serializedObject;
        this.object = ObjectUtils.memoize(payload);
    }

    public <V> V getPayload() {
        return (V)this.object.apply(Object.class);
    }

    public <V> V getPayloadAs(Class<V> type) {
        return (V)this.object.apply(type);
    }

    public boolean isDeserialized() {
        return this.object.isCached(Object.class);
    }

    public String getType() {
        return this.serializedObject.data().getType();
    }

    public int getRevision() {
        return this.serializedObject.data().getRevision();
    }

    public S getSerializedObject() {
        return this.serializedObject;
    }

    public Class<?> getPayloadClass() {
        return Class.forName(this.getType());
    }

    public String toString() {
        return "DeserializingObject(serializedObject=" + this.getSerializedObject() + ")";
    }
}

