/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.cli;

import ch.qos.logback.classic.Level;
import io.engineblock.metrics.IndicatorMode;
import io.engineblock.util.EngineBlockFiles;
import io.engineblock.util.Unit;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBCLIOptions {
    public static final String docoptFileName = "commandline.md";
    private static final Logger logger = LoggerFactory.getLogger(EBCLIOptions.class);
    private static final String HELP = "--help";
    private static final String ADVANCED_HELP = "--advanced-help";
    private static final String METRICS = "--list-metrics";
    private static final String ACTIVITY_TYPES = "--list-activity-types";
    private static final String WANTS_VERSION_LONG = "--version";
    private static final String SHOW_SCRIPT = "--show-script";
    private static final String LOG_HISTO = "--log-histograms";
    private static final String LOG_STATS = "--log-histostats";
    private static final String ACTIVITY = "activity";
    private static final String RUN_ACTIVITY = "run";
    private static final String START_ACTIVITY = "start";
    private static final String STOP_ACTIVITY = "stop";
    private static final String AWAIT_ACTIVITY = "await";
    private static final String WAIT_MILLIS = "waitmillis";
    private static final String SCRIPT = "script";
    private static final String SESSION_NAME = "--session-name";
    private static final String LOG_DIR = "--log-dir";
    private static final String MAX_LOGS = "--log-max";
    private static final String WANTS_INFO_CONSOLE_LOGGING = "-v";
    private static final String WANTS_DEBUG_CONSOLE_LOGGING = "-vv";
    private static final String WANTS_TRACE_CONSOLE_LOGGING = "-vvv";
    private static final String REPORT_GRAPHITE_TO = "--report-graphite-to";
    private static final String REPORT_CSV_TO = "--report-csv-to";
    private static final String METRICS_PREFIX = "--metrics-prefix";
    private static final String PROGRESS_INDICATOR = "--progress";
    private static final Set<String> reserved_words = new HashSet<String>(){
        {
            this.addAll(Arrays.asList(EBCLIOptions.ACTIVITY, EBCLIOptions.SCRIPT, EBCLIOptions.ACTIVITY_TYPES, EBCLIOptions.HELP, EBCLIOptions.METRICS_PREFIX, EBCLIOptions.REPORT_GRAPHITE_TO));
        }
    };
    private LinkedList<Cmd> cmdList = new LinkedList();
    private int maxLogs = 0;
    private boolean wantsVersion = false;
    private boolean wantsActivityHelp = false;
    private String wantsActivityHelpFor;
    private boolean wantsActivityTypes = false;
    private boolean wantsBasicHelp = false;
    private String reportGraphiteTo = null;
    private String reportCsvTo = null;
    private String metricsPrefix = "engineblock.";
    private String wantsMetricsForActivity;
    private boolean wantsAdvancedHelp = false;
    private String sessionName = "";
    private boolean showScript = false;
    private Level consoleLevel = Level.WARN;
    private List<String> histoLoggerConfigs = new ArrayList<String>();
    private List<String> statsLoggerConfigs = new ArrayList<String>();
    private String progressSpec = "console:1m";
    private String logDirectory = "logs";

    EBCLIOptions(String[] args) {
        this.parse(args);
    }

    private void parse(final String[] args) {
        LinkedList<String> arglist = new LinkedList<String>(){
            {
                this.addAll(Arrays.asList(args));
            }
        };
        if (arglist.peekFirst() == null) {
            this.wantsBasicHelp = true;
            return;
        }
        block55: while (arglist.peekFirst() != null) {
            String word;
            switch (word = (String)arglist.peekFirst()) {
                case "--show-script": {
                    arglist.removeFirst();
                    this.showScript = true;
                    continue block55;
                }
                case "activity": {
                    arglist.removeFirst();
                    arglist.addFirst(RUN_ACTIVITY);
                }
                case "start": 
                case "run": {
                    Cmd activity = this.parseActivityCmd(arglist);
                    this.cmdList.add(activity);
                    continue block55;
                }
                case "--list-metrics": {
                    arglist.removeFirst();
                    arglist.addFirst(START_ACTIVITY);
                    Cmd introspectActivity = this.parseActivityCmd(arglist);
                    this.wantsMetricsForActivity = introspectActivity.cmdSpec;
                    continue block55;
                }
                case "await": {
                    String awaitCmdType = (String)arglist.removeFirst();
                    String activityToAwait = this.readWordOrThrow(arglist, "activity alias to await");
                    this.assertNotParameter(activityToAwait);
                    this.assertNotReserved(activityToAwait);
                    Cmd awaitActivityCmd = new Cmd(CmdType.valueOf(awaitCmdType), activityToAwait);
                    this.cmdList.add(awaitActivityCmd);
                    continue block55;
                }
                case "stop": {
                    String stopCmdType = this.readWordOrThrow(arglist, "stop command");
                    String activityToStop = this.readWordOrThrow(arglist, "activity alias to await");
                    this.assertNotParameter(activityToStop);
                    this.assertNotReserved(activityToStop);
                    Cmd stopActivityCmd = new Cmd(CmdType.valueOf(stopCmdType), activityToStop);
                    this.cmdList.add(stopActivityCmd);
                    continue block55;
                }
                case "waitmillis": {
                    String waitMillisCmdType = this.readWordOrThrow(arglist, "wait millis");
                    String millisCount = this.readWordOrThrow(arglist, "millis count");
                    Long.parseLong(millisCount);
                    Cmd awaitMillisCmd = new Cmd(CmdType.valueOf(waitMillisCmdType), millisCount);
                    this.cmdList.add(awaitMillisCmd);
                    continue block55;
                }
                case "script": {
                    Cmd cmd = this.parseScriptCmd(arglist);
                    this.cmdList.add(cmd);
                    continue block55;
                }
                case "--session-name": {
                    arglist.removeFirst();
                    this.sessionName = this.readWordOrThrow(arglist, "a session name");
                    continue block55;
                }
                case "--log-dir": {
                    arglist.removeFirst();
                    this.logDirectory = this.readWordOrThrow(arglist, "a log directory");
                    continue block55;
                }
                case "--log-max": {
                    arglist.removeFirst();
                    this.maxLogs = Integer.valueOf(this.readWordOrThrow(arglist, "max logfiles to keep"));
                    continue block55;
                }
                case "--progress": {
                    arglist.removeFirst();
                    this.progressSpec = this.readWordOrThrow(arglist, "a progress indicator, like 'log:1m' or 'screen:10s', or just 'log' or 'screen'");
                    continue block55;
                }
                case "--version": {
                    arglist.removeFirst();
                    this.wantsVersion = true;
                    continue block55;
                }
                case "--advanced-help": {
                    arglist.removeFirst();
                    this.wantsAdvancedHelp = true;
                    continue block55;
                }
                case "--help": 
                case "-h": 
                case "help": {
                    arglist.removeFirst();
                    if (arglist.peekFirst() == null) {
                        this.wantsBasicHelp = true;
                        logger.info("getting basic help");
                        continue block55;
                    }
                    this.wantsActivityHelp = true;
                    this.wantsActivityHelpFor = (String)arglist.removeFirst();
                    continue block55;
                }
                case "--log-histograms": {
                    arglist.removeFirst();
                    String logto = (String)arglist.removeFirst();
                    this.histoLoggerConfigs.add(logto);
                    continue block55;
                }
                case "--log-histostats": {
                    arglist.removeFirst();
                    String logStatsTo = (String)arglist.removeFirst();
                    this.statsLoggerConfigs.add(logStatsTo);
                    continue block55;
                }
                case "--report-csv-to": {
                    arglist.removeFirst();
                    this.reportCsvTo = (String)arglist.removeFirst();
                    continue block55;
                }
                case "--report-graphite-to": {
                    arglist.removeFirst();
                    this.reportGraphiteTo = (String)arglist.removeFirst();
                    continue block55;
                }
                case "--metrics-prefix": {
                    arglist.removeFirst();
                    this.metricsPrefix = (String)arglist.removeFirst();
                    continue block55;
                }
                case "--list-activity-types": {
                    arglist.removeFirst();
                    this.wantsActivityTypes = true;
                    continue block55;
                }
                case "-vv": {
                    this.consoleLevel = Level.DEBUG;
                    arglist.removeFirst();
                    continue block55;
                }
                case "-v": {
                    this.consoleLevel = Level.INFO;
                    arglist.removeFirst();
                    continue block55;
                }
                case "-vvv": {
                    this.consoleLevel = Level.TRACE;
                    arglist.removeFirst();
                    continue block55;
                }
            }
            Optional optionalScript = EngineBlockFiles.findOptionalStreamOrFile((String)word, (String)"js", (String[])new String[]{"scripts/auto"});
            if (optionalScript.isPresent()) {
                arglist.removeFirst();
                arglist.addFirst("scripts/auto/" + word);
                arglist.addFirst(SCRIPT);
                Cmd script = this.parseScriptCmd(arglist);
                this.cmdList.add(script);
                continue;
            }
            throw new InvalidParameterException("unrecognized option:" + word);
        }
    }

    public List<LoggerConfig> getHistoLoggerConfigs() {
        List<LoggerConfig> configs = this.histoLoggerConfigs.stream().map(LoggerConfig::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, LOG_HISTO);
        return configs;
    }

    public List<LoggerConfig> getStatsLoggerConfigs() {
        List<LoggerConfig> configs = this.statsLoggerConfigs.stream().map(LoggerConfig::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, LOG_STATS);
        return configs;
    }

    public List<Cmd> getCommands() {
        return this.cmdList;
    }

    public boolean wantsShowScript() {
        return this.showScript;
    }

    public boolean wantsVersion() {
        return this.wantsVersion;
    }

    public boolean wantsActivityTypes() {
        return this.wantsActivityTypes;
    }

    public boolean wantsTopicalHelp() {
        return this.wantsActivityHelp;
    }

    public String wantsTopicalHelpFor() {
        return this.wantsActivityHelpFor;
    }

    public boolean wantsBasicHelp() {
        return this.wantsBasicHelp;
    }

    public boolean wantsAdvancedHelp() {
        return this.wantsAdvancedHelp;
    }

    public String wantsReportGraphiteTo() {
        return this.reportGraphiteTo;
    }

    public String wantsMetricsPrefix() {
        return this.metricsPrefix;
    }

    public String wantsMetricsForActivity() {
        return this.wantsMetricsForActivity;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public Level wantsConsoleLogLevel() {
        return this.consoleLevel;
    }

    private void assertNotParameter(String scriptName) {
        if (scriptName.contains("=")) {
            throw new InvalidParameterException("script name must precede script arguments");
        }
    }

    private void assertNotReserved(String name) {
        if (reserved_words.contains(name)) {
            throw new InvalidParameterException(name + " is a reserved word and may not be used here.");
        }
    }

    private String readOptionally(LinkedList<String> argList) {
        return argList.pollFirst();
    }

    private String readWordOrThrow(LinkedList<String> arglist, String required) {
        if (arglist.peekFirst() == null) {
            throw new InvalidParameterException(required + " not found");
        }
        return arglist.removeFirst();
    }

    private Cmd parseScriptCmd(LinkedList<String> arglist) {
        String cmdType = arglist.removeFirst();
        String scriptName = this.readWordOrThrow(arglist, "script name");
        this.assertNotReserved(scriptName);
        this.assertNotParameter(scriptName);
        LinkedHashMap<String, String> scriptParams = new LinkedHashMap<String, String>();
        while (arglist.size() > 0 && !reserved_words.contains(arglist.peekFirst()) && arglist.peekFirst().contains("=")) {
            String[] split = arglist.removeFirst().split("=", 2);
            scriptParams.put(split[0], split[1]);
        }
        return new Cmd(CmdType.script, scriptName, scriptParams);
    }

    private Cmd parseActivityCmd(LinkedList<String> arglist) {
        String cmdType = arglist.removeFirst();
        ArrayList<String> activitydef = new ArrayList<String>();
        while (arglist.size() > 0 && !reserved_words.contains(arglist.peekFirst()) && arglist.peekFirst().contains("=")) {
            activitydef.add(arglist.removeFirst());
        }
        return new Cmd(CmdType.valueOf(cmdType), activitydef.stream().map(s -> s + ";").collect(Collectors.joining()));
    }

    public String getProgressSpec() {
        ProgressSpec spec = this.parseProgressSpec(this.progressSpec);
        if (spec.indicatorMode == IndicatorMode.console && Level.INFO.isGreaterOrEqual(this.wantsConsoleLogLevel())) {
            logger.warn("Console is already logging info or more, so progress data on console is suppressed.");
            spec.indicatorMode = IndicatorMode.logonly;
        }
        return spec.toString();
    }

    private void checkLoggerConfigs(List<LoggerConfig> configs, String configName) {
        HashSet files = new HashSet();
        configs.stream().map(LoggerConfig::getFilename).forEach(s -> {
            if (files.contains(s)) {
                logger.warn(s + " is included in " + configName + " more than once. It will only be included in the first matching config. Reorder your options if you need to control this.");
            }
            files.add(s);
        });
    }

    public String wantsReportCsvTo() {
        return this.reportCsvTo;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public int getMaxLogs() {
        return this.maxLogs;
    }

    private ProgressSpec parseProgressSpec(String interval) {
        ProgressSpec progressSpec = new ProgressSpec();
        String[] parts = interval.split(":");
        switch (parts.length) {
            case 2: {
                Unit.msFor((String)parts[1]).orElseThrow(() -> new RuntimeException("Unable to parse progress indicator indicatorSpec '" + parts[1] + "'"));
                progressSpec.intervalSpec = parts[1];
            }
            case 1: {
                progressSpec.indicatorMode = IndicatorMode.valueOf((String)parts[0]);
                break;
            }
            default: {
                throw new RuntimeException("This should never happen.");
            }
        }
        return progressSpec;
    }

    private static class ProgressSpec {
        public String intervalSpec;
        public IndicatorMode indicatorMode;

        private ProgressSpec() {
        }

        public String toString() {
            return this.indicatorMode.toString() + ":" + this.intervalSpec;
        }
    }

    public static class LoggerConfig {
        public String file = "";
        public String pattern = ".*";
        public String interval = "30 seconds";

        public LoggerConfig(String histoLoggerSpec) {
            String[] words = histoLoggerSpec.split(":");
            switch (words.length) {
                case 3: {
                    this.interval = words[2].isEmpty() ? this.interval : words[2];
                }
                case 2: {
                    this.pattern = words[1].isEmpty() ? this.pattern : words[1];
                }
                case 1: {
                    this.file = words[0];
                    if (!this.file.isEmpty()) break;
                    throw new RuntimeException("You must not specify an empty file here for logging data.");
                }
                default: {
                    throw new RuntimeException("--log-histograms options must be in either 'regex:filename:interval' or 'regex:filename' or 'filename' format");
                }
            }
        }

        public String getFilename() {
            return this.file;
        }
    }

    public static class Cmd {
        public CmdType cmdType;
        public String cmdSpec;
        public Map<String, String> cmdArgs;

        public Cmd(CmdType cmdType, String cmdSpec) {
            this.cmdSpec = cmdSpec;
            this.cmdType = cmdType;
        }

        public Cmd(CmdType cmdType, String cmdSpec, Map<String, String> cmdArgs) {
            this(cmdType, cmdSpec);
            this.cmdArgs = cmdArgs;
        }

        public String getCmdSpec() {
            return this.cmdSpec;
        }

        public CmdType getCmdType() {
            return this.cmdType;
        }

        public Map<String, String> getCmdArgs() {
            return this.cmdArgs;
        }

        public String toString() {
            return "type:" + (Object)((Object)this.cmdType) + ";spec=" + this.cmdSpec + (this.cmdArgs != null ? ";cmdArgs=" + this.cmdArgs.toString() : "");
        }
    }

    public static enum CmdType {
        start,
        run,
        stop,
        await,
        script,
        waitmillis;

    }
}

