/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.writebehind.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.write.MapStorageWriter;
import io.datarouter.virtualnode.writebehind.WriteBehindNode;
import io.datarouter.virtualnode.writebehind.base.WriteWrapper;
import java.util.Collection;
import java.util.Collections;

public interface WriteBehindMapStorageWriterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, N extends MapStorage<PK, D>>
extends MapStorageWriter<PK, D>,
WriteBehindNode<PK, D, N> {
    default public void delete(PK key, Config config) {
        this.getQueue().offer(new WriteWrapper<PK>("delete", Collections.singletonList(key), config));
    }

    default public void deleteMulti(Collection<PK> keys, Config config) {
        this.getQueue().offer(new WriteWrapper<PK>("delete", keys, config));
    }

    default public void deleteAll(Config config) {
        this.getQueue().offer(new WriteWrapper<Object>("deleteAll", Collections.singletonList(new Object()), config));
    }

    default public void put(D databean, Config config) {
        this.putMulti(Collections.singletonList(databean), config);
    }

    default public void putMulti(Collection<D> databeans, Config config) {
        this.getQueue().offer(new WriteWrapper<D>("put", databeans, config));
    }

    @Override
    default public boolean handleWriteWrapperInternal(WriteWrapper<?> writeWrapper) {
        if (writeWrapper.getOp().equals("put")) {
            ((MapStorage)this.getBackingNode()).putMulti(writeWrapper.getObjects(), writeWrapper.getConfig());
        } else if (writeWrapper.getOp().equals("delete")) {
            ((MapStorage)this.getBackingNode()).deleteMulti(writeWrapper.getObjects(), writeWrapper.getConfig());
        } else if (writeWrapper.getOp().equals("deleteAll")) {
            ((MapStorage)this.getBackingNode()).deleteAll(writeWrapper.getConfig());
        } else {
            return false;
        }
        return true;
    }
}

