/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.writebehind.base;

import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.virtualnode.writebehind.base.BaseWriteBehindNode;
import io.datarouter.virtualnode.writebehind.base.OutstandingWriteWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueWriteCanceller
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OverdueWriteCanceller.class);
    protected final BaseWriteBehindNode<?, ?, ?> node;

    public OverdueWriteCanceller(BaseWriteBehindNode<?, ?, ?> node) {
        this.node = node;
    }

    @Override
    public void run() {
        try {
            OutstandingWriteWrapper writeWrapper;
            if (this.node.outstandingWrites == null) {
                return;
            }
            while ((writeWrapper = this.node.outstandingWrites.peek()) != null) {
                boolean overdue;
                long ageMs = writeWrapper.getAgeMs();
                boolean bl = overdue = ageMs > this.node.timeoutMs;
                if (writeWrapper.write.isDone() || overdue) {
                    if (overdue) {
                        logger.warn("cancelling overdue write on {} ageMs={}", (Object)writeWrapper.opDesc, (Object)ageMs);
                        DatarouterCounters.incOp(null, (String)("writeBehind timeout on " + this.node));
                    }
                    this.node.outstandingWrites.poll();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
    }
}

