/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.replication;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.tableconfig.NodewatchConfigurationBuilder;
import io.datarouter.virtualnode.replication.ReplicationIndexedSortedMapStorageNode;
import io.datarouter.virtualnode.replication.ReplicationMapStorageNode;
import io.datarouter.virtualnode.replication.ReplicationSortedMapStorageNode;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReplicationNodeFactory {
    @Inject
    private Datarouter datarouter;
    @Inject
    private NodeFactory nodeFactory;

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId primaryClientId, Collection<ClientId> replicaClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        NodeOps primary = this.nodeFactory.create(primaryClientId, databeanSupplier, fielderSupplier).build();
        Function<ClientId, NodeOps> buildReplicaFunction = clientId -> this.nodeFactory.create(clientId, databeanSupplier, fielderSupplier).build();
        List replicas = Scanner.of(replicaClientIds).map(buildReplicaFunction).list();
        return (N)ReplicationNodeFactory.make(primary, replicas);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId primaryClientId, Collection<ClientId> replicaClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String tableName) {
        NodeOps primary = this.nodeFactory.create(primaryClientId, databeanSupplier, fielderSupplier).withTableName(tableName).build();
        Function<ClientId, NodeOps> buildReplicaFunction = clientId -> this.nodeFactory.create(clientId, databeanSupplier, fielderSupplier).withTableName(tableName).build();
        List replicas = Scanner.of(replicaClientIds).map(buildReplicaFunction).list();
        return (N)ReplicationNodeFactory.make(primary, replicas);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId primaryClientId, Collection<ClientId> replicaClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, NodewatchConfigurationBuilder nodewatchConfigurationBuilder) {
        NodeOps primary = this.nodeFactory.create(primaryClientId, databeanSupplier, fielderSupplier).withNodewatchConfigurationBuilder(nodewatchConfigurationBuilder).build();
        Function<ClientId, NodeOps> buildReplicaFunction = clientId -> this.nodeFactory.create(clientId, databeanSupplier, fielderSupplier).build();
        List replicas = Scanner.of(replicaClientIds).map(buildReplicaFunction).list();
        return (N)ReplicationNodeFactory.make(primary, replicas);
    }

    public <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId primaryClientId, Collection<ClientId> replicaClientIds, Supplier<EK> entityKeySupplier, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        NodeOps primary = this.nodeFactory.create(primaryClientId, entityKeySupplier, databeanSupplier, fielderSupplier).build();
        Function<ClientId, NodeOps> buildReplicaFunction = clientId -> this.nodeFactory.create(clientId, entityKeySupplier, databeanSupplier, fielderSupplier).build();
        List replicas = Scanner.of(replicaClientIds).map(buildReplicaFunction).list();
        return (N)ReplicationNodeFactory.make(primary, replicas);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N register(ClientId primaryClientId, Collection<ClientId> replicaClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return (N)((NodeOps)this.datarouter.register(this.build(primaryClientId, replicaClientIds, databeanSupplier, fielderSupplier)));
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N register(ClientId primaryClientId, Collection<ClientId> replicaClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String tableName) {
        return (N)((NodeOps)this.datarouter.register(this.build(primaryClientId, replicaClientIds, databeanSupplier, fielderSupplier, tableName)));
    }

    public static <PK extends EntityPrimaryKey<?, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N make(N primary, List<N> replicas) {
        if (primary instanceof IndexedSortedMapStorage.IndexedSortedMapStorageNode) {
            IndexedSortedMapStorage.IndexedSortedMapStorageNode typedPrimary = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)primary;
            List<N> typedReplicas = replicas;
            return (N)new ReplicationIndexedSortedMapStorageNode(typedPrimary, typedReplicas);
        }
        if (primary instanceof SortedMapStorage.SortedMapStorageNode) {
            SortedMapStorage.SortedMapStorageNode typedPrimary = (SortedMapStorage.SortedMapStorageNode)primary;
            List<N> typedReplicas = replicas;
            return (N)new ReplicationSortedMapStorageNode(typedPrimary, typedReplicas);
        }
        if (primary instanceof MapStorage.MapStorageNode) {
            MapStorage.MapStorageNode typedPrimary = (MapStorage.MapStorageNode)primary;
            List<N> typedReplicas = replicas;
            return (N)new ReplicationMapStorageNode(typedPrimary, typedReplicas);
        }
        throw new UnsupportedOperationException("No ReplicationNode implementation found for " + primary.getClass());
    }
}

