/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.replication;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.virtualnode.replication.ReplicationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public abstract class BaseReplicationNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseNode<PK, D, F>
implements ReplicationNode<PK, D, F, N> {
    protected final N primary;
    protected final List<N> replicas = new ArrayList<N>();
    protected final List<N> primaryAndReplicas = new ArrayList<N>();
    protected final AtomicInteger replicaRequestCounter = new AtomicInteger(0);

    public BaseReplicationNode(N primary, Collection<N> replicas) {
        super(new NodeParams.NodeParamsBuilder(primary.getFieldInfo().getDatabeanSupplier(), primary.getFieldInfo().getFielderSupplier()).build());
        this.primary = primary;
        this.primaryAndReplicas.add(primary);
        this.replicas.addAll(replicas);
        this.primaryAndReplicas.addAll(replicas);
    }

    public String getName() {
        return this.primaryAndReplicas.stream().map(Node::getName).collect(Collectors.joining(",", String.valueOf(this.getClass().getSimpleName()) + "[", "]"));
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodes() {
        ArrayList<PhysicalNode<PK, D, F>> all = new ArrayList<PhysicalNode<PK, D, F>>();
        all.addAll(this.primary.getPhysicalNodes());
        this.replicas.stream().map(Node::getPhysicalNodes).forEach(all::addAll);
        return all;
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        ArrayList<PhysicalNode<PK, D, F>> all = new ArrayList<PhysicalNode<PK, D, F>>();
        all.addAll(this.primary.getPhysicalNodesForClient(clientName));
        this.replicas.stream().map(replica -> replica.getPhysicalNodesForClient(clientName)).forEach(all::addAll);
        return all;
    }

    public List<ClientId> getClientIds() {
        HashSet clientIds = new HashSet(this.primary.getClientIds());
        this.replicas.stream().map(Node::getClientIds).forEach(clientIds::addAll);
        return new ArrayList<ClientId>(clientIds);
    }

    public boolean usesClient(String clientName) {
        if (this.primary.usesClient(clientName)) {
            return true;
        }
        return this.replicas.stream().filter(replica -> replica.usesClient(clientName)).findAny().isPresent();
    }

    @Override
    public N getPrimary() {
        return this.primary;
    }

    @Override
    public List<N> getChildNodes() {
        return this.primaryAndReplicas;
    }

    @Override
    public N chooseReplica(Config config) {
        if (this.replicas.isEmpty()) {
            return this.primary;
        }
        int replicaIndex = this.replicaRequestCounter.incrementAndGet() % this.replicas.size();
        return (N)((Node)this.replicas.get(replicaIndex));
    }
}

