/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.redundant.base;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.util.Require;
import io.datarouter.virtualnode.redundant.RedundantNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseRedundantNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseNode<PK, D, F>
implements RedundantNode<PK, D, F, N> {
    protected final List<N> writeNodes;
    protected final N readNode;

    public BaseRedundantNode(List<N> writeNodes, N readNode) {
        super(new NodeParams.NodeParamsBuilder(readNode.getFieldInfo().getDatabeanSupplier(), readNode.getFieldInfo().getFielderSupplier()).build());
        this.writeNodes = (List)Require.notEmpty(writeNodes, (String)"writeNodes cannot be empty");
        this.readNode = (Node)Objects.requireNonNull(readNode);
        Require.contains(writeNodes, readNode, (String)"readNode must be in writeNodes.");
    }

    public String getName() {
        return Stream.concat(Stream.of(this.readNode), this.writeNodes.stream()).map(Node::getName).collect(Collectors.joining(",", String.valueOf(this.getClass().getSimpleName()) + "[", "]"));
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodes() {
        return this.writeNodes.stream().map(Node::getPhysicalNodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        return this.writeNodes.stream().map(backingNode -> backingNode.getPhysicalNodesForClient(clientName)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ClientId> getClientIds() {
        return this.writeNodes.stream().map(Node::getClientIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public boolean usesClient(String clientName) {
        return this.writeNodes.stream().anyMatch(backingNode -> backingNode.usesClient(clientName));
    }

    public List<N> getChildNodes() {
        return this.writeNodes;
    }

    @Override
    public List<N> getWriteNodes() {
        return this.writeNodes;
    }

    @Override
    public N getReadNode() {
        return this.readNode;
    }
}

