/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.caching;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.virtualnode.caching.BaseMapCachingNode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MapCachingMapStorageReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends BaseMapCachingNode<PK, D, F, N>
implements MapStorageReader.MapStorageReaderNode<PK, D, F> {
    private static final Config DEFAULT_CACHING_NODE_CONFIG = new Config().setTimeout(Duration.ofMillis(100L));
    protected final boolean cacheReads;

    public MapCachingMapStorageReaderNode(N cacheNode, N backingNode, boolean cacheReads) {
        super(cacheNode, backingNode);
        this.cacheReads = cacheReads;
    }

    public static Config getEffectiveCachingNodeConfig(Config givenConfig) {
        if (givenConfig == null) {
            return DEFAULT_CACHING_NODE_CONFIG;
        }
        givenConfig = givenConfig.clone();
        givenConfig.setIgnoreException(Boolean.valueOf(true));
        if (givenConfig.getTimeout() != null && givenConfig.getTimeout().toMillis() <= DEFAULT_CACHING_NODE_CONFIG.getTimeout().toMillis()) {
            return givenConfig;
        }
        givenConfig.setTimeout(DEFAULT_CACHING_NODE_CONFIG.getTimeout());
        return givenConfig;
    }

    public boolean exists(PK key, Config config) {
        block4: {
            if (!MapCachingMapStorageReaderNode.useCache(config)) {
                return ((MapStorage.MapStorageNode)this.backingNode).exists(key, config);
            }
            try {
                this.updateLastAttemptedContact();
                if (!((MapStorage.MapStorageNode)this.cachingNode).exists(key, MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config))) break block4;
                this.countHits();
                return true;
            }
            catch (Exception e) {
                this.countExceptions();
                return ((MapStorage.MapStorageNode)this.backingNode).exists(key, config);
            }
        }
        this.updateLastContact();
        this.countMisses();
        return ((MapStorage.MapStorageNode)this.backingNode).exists(key, config);
    }

    public D get(PK key, Config config) {
        Databean cachedObject;
        if (!MapCachingMapStorageReaderNode.useCache(config)) {
            return (D)((MapStorage.MapStorageNode)this.backingNode).get(key, config);
        }
        Config effectiveCachingNodeConfig = MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config);
        try {
            this.updateLastAttemptedContact();
            cachedObject = ((MapStorage.MapStorageNode)this.cachingNode).get(key, effectiveCachingNodeConfig);
            this.updateLastContact();
        }
        catch (Exception e) {
            this.countExceptions();
            return (D)((MapStorage.MapStorageNode)this.backingNode).get(key, config);
        }
        if (cachedObject != null) {
            this.countHits();
            return (D)cachedObject;
        }
        Databean realObject = ((MapStorage.MapStorageNode)this.backingNode).get(key, config);
        if (realObject != null) {
            this.countMisses();
            if (this.cacheReads) {
                try {
                    this.updateLastAttemptedContact();
                    ((MapStorage.MapStorageNode)this.cachingNode).put(realObject, effectiveCachingNodeConfig);
                    this.updateLastContact();
                }
                catch (Exception e) {
                    this.countExceptions();
                }
            }
        }
        return (D)realObject;
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        if (!MapCachingMapStorageReaderNode.useCache(config)) {
            return ((MapStorage.MapStorageNode)this.backingNode).getMulti(keys, config);
        }
        ArrayList<D> resultBuilder = new ArrayList<D>();
        try {
            this.updateLastAttemptedContact();
            resultBuilder.addAll(((MapStorage.MapStorageNode)this.cachingNode).getMulti(keys, MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config)));
            this.updateLastContact();
        }
        catch (Exception e) {
            this.countExceptions();
            return ((MapStorage.MapStorageNode)this.backingNode).getMulti(keys, config);
        }
        this.countHits();
        Set cachedKeys = resultBuilder.stream().map(Databean::getKey).collect(Collectors.toSet());
        Set uncachedKeys = keys.stream().filter(Predicate.not(cachedKeys::contains)).collect(Collectors.toSet());
        if (uncachedKeys.isEmpty()) {
            return resultBuilder;
        }
        List<D> fromBackingNode = this.getAndCacheDatabeans(uncachedKeys, config);
        resultBuilder.addAll(fromBackingNode);
        return resultBuilder;
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        if (!MapCachingMapStorageReaderNode.useCache(config)) {
            return ((MapStorage.MapStorageNode)this.backingNode).getKeys(keys, config);
        }
        ArrayList resultBuilder = new ArrayList();
        try {
            this.updateLastAttemptedContact();
            resultBuilder.addAll(((MapStorage.MapStorageNode)this.cachingNode).getKeys(keys, MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config)));
            this.updateLastContact();
        }
        catch (Exception e) {
            this.countExceptions();
            return ((MapStorage.MapStorageNode)this.backingNode).getKeys(keys, config);
        }
        this.countHits();
        HashSet cachedKeys = new HashSet(resultBuilder);
        Set uncachedKeys = keys.stream().filter(Predicate.not(cachedKeys::contains)).collect(Collectors.toSet());
        if (uncachedKeys.isEmpty()) {
            return resultBuilder;
        }
        List<D> fromBackingNode = this.getAndCacheDatabeans(uncachedKeys, config);
        Scanner.of(fromBackingNode).map(Databean::getKey).forEach(resultBuilder::add);
        return resultBuilder;
    }

    private List<D> getAndCacheDatabeans(Collection<PK> uncachedKeys, Config config) {
        List fromBackingNode = ((MapStorage.MapStorageNode)this.backingNode).getMulti(uncachedKeys, config);
        this.countMisses();
        if (this.cacheReads) {
            try {
                this.updateLastAttemptedContact();
                ((MapStorage.MapStorageNode)this.cachingNode).putMulti((Collection)fromBackingNode, MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config));
                this.updateLastContact();
            }
            catch (Exception e) {
                this.countExceptions();
            }
        }
        return fromBackingNode;
    }

    private void countHits() {
        DatarouterCounters.incOp(null, (String)(String.valueOf(this.getName()) + " hit"));
    }

    private void countMisses() {
        DatarouterCounters.incOp(null, (String)(String.valueOf(this.getName()) + " miss"));
    }

    private void countExceptions() {
        DatarouterCounters.incOp(null, (String)(String.valueOf(this.getName()) + " exception"));
    }
}

