/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.redundant.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.GroupQueueStorage;
import io.datarouter.storage.queue.GroupQueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.virtualnode.redundant.RedundantQueueNode;
import io.datarouter.virtualnode.redundant.mixin.SqsRedundantNodeTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RedundantGroupQueueStorageMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends GroupQueueStorage.GroupQueueStorageNode<PK, D, F>>
extends GroupQueueStorage<PK, D>,
RedundantQueueNode<PK, D, F, N> {
    public static final Logger logger = LoggerFactory.getLogger(RedundantGroupQueueStorageMixin.class);

    default public List<D> pollMulti(Config config) {
        return this.getReadNodes().stream().map(node -> node.pollMulti(config)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public void ack(QueueMessageKey key, Config config) {
        PhaseTimer phaseTimer = new PhaseTimer();
        for (GroupQueueStorage.GroupQueueStorageNode node : this.getReadNodes()) {
            try {
                node.ack(key, config);
                phaseTimer.add("success " + node);
                return;
            }
            catch (RuntimeException e) {
                SqsRedundantNodeTool.swallowIfNotFound(e, node);
                phaseTimer.add("failed node " + node);
            }
        }
    }

    default public void ackMulti(Collection<QueueMessageKey> keys, Config config) {
        PhaseTimer phaseTimer = new PhaseTimer();
        for (GroupQueueStorage.GroupQueueStorageNode node : this.getReadNodes()) {
            try {
                node.ackMulti(keys, config);
                phaseTimer.add("success " + node);
                return;
            }
            catch (RuntimeException e) {
                SqsRedundantNodeTool.swallowIfNotFound(e, node);
                phaseTimer.add("failed node " + node);
            }
        }
    }

    default public void put(D databean, Config config) {
        ((GroupQueueStorage.GroupQueueStorageNode)this.getWriteNode()).put(databean, config);
    }

    default public void putMulti(Collection<D> databeans, Config config) {
        ((GroupQueueStorage.GroupQueueStorageNode)this.getWriteNode()).putMulti(databeans, config);
    }

    default public GroupQueueMessage<PK, D> peek(Config config) {
        PhaseTimer phaseTimer = new PhaseTimer();
        ArrayList readerNodes = new ArrayList(this.getReadNodes());
        Collections.shuffle(readerNodes);
        for (GroupQueueStorage.GroupQueueStorageNode node : readerNodes) {
            GroupQueueMessage databean = node.peek(config);
            phaseTimer.add("node " + node);
            if (databean == null) continue;
            return databean;
        }
        return null;
    }

    default public List<GroupQueueMessage<PK, D>> peekMulti(Config config) {
        PhaseTimer phaseTimer = new PhaseTimer();
        for (GroupQueueStorage.GroupQueueStorageNode node : this.getReadNodes()) {
            List messages = node.peekMulti(config);
            phaseTimer.add("node " + node);
            if (messages.isEmpty()) continue;
            return messages;
        }
        return Collections.emptyList();
    }

    default public Iterable<GroupQueueMessage<PK, D>> peekUntilEmpty(Config config) {
        ArrayList messages = new ArrayList();
        this.getReadNodes().forEach(node -> node.peekUntilEmpty(config).iterator().forEachRemaining(messages::add));
        return messages;
    }
}

