/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.redundant.base;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.util.Require;
import io.datarouter.virtualnode.redundant.RedundantQueueNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseRedundantQueueNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseNode<PK, D, F>
implements RedundantQueueNode<PK, D, F, N> {
    protected final N writeNode;
    protected final List<N> readNodes;

    public BaseRedundantQueueNode(N writeNode, List<N> readNodes) {
        super(new NodeParams.NodeParamsBuilder(writeNode.getFieldInfo().getDatabeanSupplier(), writeNode.getFieldInfo().getFielderSupplier()).build());
        this.readNodes = (List)Require.notEmpty(readNodes, (String)"readNodes cannot be empty");
        this.writeNode = (Node)Objects.requireNonNull(writeNode);
        Require.contains(readNodes, writeNode, (String)"writeNode must be in readNodes.");
    }

    public String getName() {
        return Stream.concat(Stream.of(this.writeNode), this.readNodes.stream()).map(Node::getName).collect(Collectors.joining(",", String.valueOf(this.getClass().getSimpleName()) + "[", "]"));
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodes() {
        return this.readNodes.stream().map(Node::getPhysicalNodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        return this.readNodes.stream().map(backingNode -> backingNode.getPhysicalNodesForClient(clientName)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ClientId> getClientIds() {
        return this.readNodes.stream().map(Node::getClientIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public boolean usesClient(String clientName) {
        return this.readNodes.stream().anyMatch(backingNode -> backingNode.usesClient(clientName));
    }

    public List<N> getChildNodes() {
        return this.readNodes;
    }

    @Override
    public List<N> getReadNodes() {
        return this.readNodes;
    }

    @Override
    public N getWriteNode() {
        return this.writeNode;
    }
}

