/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.masterslave;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.tableconfig.TableConfigurationFactory;
import io.datarouter.util.iterable.IterableTool;
import io.datarouter.virtualnode.masterslave.MasterSlaveIndexedSortedMapStorageNode;
import io.datarouter.virtualnode.masterslave.MasterSlaveMapStorageNode;
import io.datarouter.virtualnode.masterslave.MasterSlaveSortedMapStorageNode;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MasterSlaveNodeFactory {
    @Inject
    private Datarouter datarouter;
    @Inject
    private NodeFactory nodeFactory;

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId masterClientId, Collection<ClientId> slaveClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        NodeOps master = this.nodeFactory.create(masterClientId, databeanSupplier, fielderSupplier).build();
        List slaves = IterableTool.map(slaveClientIds, clientId -> this.nodeFactory.create(clientId, databeanSupplier, fielderSupplier).build());
        return (N)MasterSlaveNodeFactory.make(master, slaves);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId masterClientId, Collection<ClientId> slaveClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String tableName) {
        NodeOps master = this.nodeFactory.create(masterClientId, databeanSupplier, fielderSupplier).withTableName(tableName).build();
        List slaves = IterableTool.map(slaveClientIds, clientId -> this.nodeFactory.create(clientId, databeanSupplier, fielderSupplier).withTableName(tableName).build());
        return (N)MasterSlaveNodeFactory.make(master, slaves);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId masterClientId, Collection<ClientId> slaveClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, TableConfigurationFactory tableConfigurationFactory) {
        NodeOps master = this.nodeFactory.create(masterClientId, databeanSupplier, fielderSupplier).withTableConfigurationFactory(tableConfigurationFactory).build();
        List slaves = IterableTool.map(slaveClientIds, clientId -> this.nodeFactory.create(clientId, databeanSupplier, fielderSupplier).build());
        return (N)MasterSlaveNodeFactory.make(master, slaves);
    }

    public <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N build(ClientId masterClientId, Collection<ClientId> slaveClientIds, Supplier<EK> entityKeySupplier, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        NodeOps master = this.nodeFactory.create(masterClientId, entityKeySupplier, databeanSupplier, fielderSupplier).build();
        List slaves = IterableTool.map(slaveClientIds, clientId -> this.nodeFactory.create(clientId, entityKeySupplier, databeanSupplier, fielderSupplier).build());
        return (N)MasterSlaveNodeFactory.make(master, slaves);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N register(ClientId masterClientId, Collection<ClientId> slaveClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return (N)((NodeOps)this.datarouter.register(this.build(masterClientId, slaveClientIds, databeanSupplier, fielderSupplier)));
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N register(ClientId masterClientId, Collection<ClientId> slaveClientIds, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String tableName) {
        return (N)((NodeOps)this.datarouter.register(this.build(masterClientId, slaveClientIds, databeanSupplier, fielderSupplier, tableName)));
    }

    public static <PK extends EntityPrimaryKey<?, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends NodeOps<PK, D>> N make(N master, List<N> slaves) {
        if (master instanceof IndexedSortedMapStorage.IndexedSortedMapStorageNode) {
            IndexedSortedMapStorage.IndexedSortedMapStorageNode typedMaster = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)master;
            List<N> typedSlaves = slaves;
            return (N)new MasterSlaveIndexedSortedMapStorageNode(typedMaster, typedSlaves);
        }
        if (master instanceof SortedMapStorage.SortedMapStorageNode) {
            SortedMapStorage.SortedMapStorageNode typedMaster = (SortedMapStorage.SortedMapStorageNode)master;
            List<N> typedSlaves = slaves;
            return (N)new MasterSlaveSortedMapStorageNode(typedMaster, typedSlaves);
        }
        if (master instanceof MapStorage.MapStorageNode) {
            MapStorage.MapStorageNode typedMaster = (MapStorage.MapStorageNode)master;
            List<N> typedSlaves = slaves;
            return (N)new MasterSlaveMapStorageNode(typedMaster, typedSlaves);
        }
        throw new UnsupportedOperationException("No MasterSlave implementation found for " + master.getClass());
    }
}

