/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.masterslave;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.virtualnode.masterslave.MasterSlaveNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public abstract class BaseMasterSlaveNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseNode<PK, D, F>
implements MasterSlaveNode<PK, D, F, N> {
    protected final N master;
    protected final List<N> slaves = new ArrayList<N>();
    protected final List<N> masterAndSlaves = new ArrayList<N>();
    protected final AtomicInteger slaveRequestCounter = new AtomicInteger(0);

    public BaseMasterSlaveNode(N master, Collection<N> slaves) {
        super(new NodeParams.NodeParamsBuilder(master.getFieldInfo().getDatabeanSupplier(), master.getFieldInfo().getFielderSupplier()).build());
        this.master = master;
        this.masterAndSlaves.add(master);
        this.slaves.addAll(slaves);
        this.masterAndSlaves.addAll(slaves);
    }

    public String getName() {
        return this.masterAndSlaves.stream().map(Node::getName).collect(Collectors.joining(",", String.valueOf(this.getClass().getSimpleName()) + "[", "]"));
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodes() {
        ArrayList<PhysicalNode<PK, D, F>> all = new ArrayList<PhysicalNode<PK, D, F>>();
        all.addAll(this.master.getPhysicalNodes());
        this.slaves.stream().map(Node::getPhysicalNodes).forEach(all::addAll);
        return all;
    }

    public List<PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        ArrayList<PhysicalNode<PK, D, F>> all = new ArrayList<PhysicalNode<PK, D, F>>();
        all.addAll(this.master.getPhysicalNodesForClient(clientName));
        this.slaves.stream().map(slave -> slave.getPhysicalNodesForClient(clientName)).forEach(all::addAll);
        return all;
    }

    public List<ClientId> getClientIds() {
        HashSet clientIds = new HashSet(this.master.getClientIds());
        this.slaves.stream().map(Node::getClientIds).forEach(clientIds::addAll);
        return new ArrayList<ClientId>(clientIds);
    }

    public boolean usesClient(String clientName) {
        if (this.master.usesClient(clientName)) {
            return true;
        }
        return this.slaves.stream().filter(slave -> slave.usesClient(clientName)).findAny().isPresent();
    }

    @Override
    public N getMaster() {
        return this.master;
    }

    @Override
    public List<N> getChildNodes() {
        return this.masterAndSlaves;
    }

    @Override
    public N chooseSlave(Config config) {
        if (this.slaves.isEmpty()) {
            return this.master;
        }
        int slaveIndex = this.slaveRequestCounter.incrementAndGet() % this.slaves.size();
        return (N)((Node)this.slaves.get(slaveIndex));
    }
}

