/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.caching;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.write.MapStorageWriter;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.virtualnode.caching.BaseMapCachingNode;
import io.datarouter.virtualnode.caching.MapCachingMapStorageReaderNode;
import java.util.Collection;

public class MapCachingMapStorageWriterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorageWriter.MapStorageWriterNode<PK, D, F>>
implements MapStorageWriter<PK, D> {
    protected final BaseMapCachingNode<PK, D, F, N> target;
    protected final boolean cacheWrites;

    public MapCachingMapStorageWriterMixin(BaseMapCachingNode<PK, D, F, N> target, boolean cacheWrites) {
        this.target = target;
        this.cacheWrites = cacheWrites;
    }

    public void delete(PK key, Config config) {
        if (BaseMapCachingNode.useCache(config)) {
            this.target.updateLastAttemptedContact();
            ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).delete(key, MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config));
            this.target.updateLastContact();
        }
        ((MapStorageWriter.MapStorageWriterNode)this.target.getBackingNode()).delete(key, config);
    }

    public void deleteAll(Config config) {
        if (BaseMapCachingNode.useCache(config)) {
            this.target.updateLastAttemptedContact();
            ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).deleteAll(MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config));
            this.target.updateLastContact();
        }
        ((MapStorageWriter.MapStorageWriterNode)this.target.getBackingNode()).deleteAll(config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        if (BaseMapCachingNode.useCache(config)) {
            this.target.updateLastAttemptedContact();
            ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).deleteMulti(keys, MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config));
            this.target.updateLastContact();
        }
        ((MapStorageWriter.MapStorageWriterNode)this.target.getBackingNode()).deleteMulti(keys, config);
    }

    public void put(D databean, Config config) {
        if (databean == null || databean.getKey() == null) {
            return;
        }
        if (BaseMapCachingNode.useCache(config)) {
            this.target.updateLastAttemptedContact();
            Config effectiveCachingNodeConfig = MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config);
            if (this.cacheWrites) {
                ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).put(databean, effectiveCachingNodeConfig);
            } else {
                ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).delete(databean.getKey(), effectiveCachingNodeConfig);
            }
            this.target.updateLastContact();
        }
        ((MapStorageWriter.MapStorageWriterNode)this.target.getBackingNode()).put(databean, config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        if (CollectionTool.isEmpty(databeans)) {
            return;
        }
        if (BaseMapCachingNode.useCache(config)) {
            this.target.updateLastAttemptedContact();
            Config effectiveCachingNodeConfig = MapCachingMapStorageReaderNode.getEffectiveCachingNodeConfig(config);
            if (this.cacheWrites) {
                ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).putMulti(databeans, effectiveCachingNodeConfig);
            } else {
                ((MapStorageWriter.MapStorageWriterNode)this.target.getCachingNode()).deleteMulti((Collection)DatabeanTool.getKeys(databeans), effectiveCachingNodeConfig);
            }
            this.target.updateLastContact();
        }
        ((MapStorageWriter.MapStorageWriterNode)this.target.getBackingNode()).putMulti(databeans, config);
    }
}

