/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.virtualnode.caching;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public abstract class BaseMapCachingNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseNode<PK, D, F> {
    protected final N cachingNode;
    protected final N backingNode;
    protected long lastAttemptedContact = 0L;
    protected long lastContact = 0L;

    public BaseMapCachingNode(N cacheNode, N backingNode) {
        super(new NodeParams.NodeParamsBuilder(backingNode.getFieldInfo().getDatabeanSupplier(), backingNode.getFieldInfo().getFielderSupplier()).build());
        this.cachingNode = cacheNode;
        this.backingNode = backingNode;
    }

    public void updateLastAttemptedContact() {
        this.lastAttemptedContact = System.currentTimeMillis();
    }

    public void updateLastContact() {
        this.lastContact = System.currentTimeMillis();
    }

    public static boolean useCache(Config config) {
        if (config == null || config.getCacheOk() == null) {
            return Config.DEFAULT_CACHE_OK;
        }
        return config.getCacheOk();
    }

    public String getName() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "[" + this.cachingNode.getName() + "," + this.backingNode.getName() + "]";
    }

    public List<ClientId> getClientIds() {
        HashSet clientIds = new HashSet(this.backingNode.getClientIds());
        clientIds.addAll(this.cachingNode.getClientIds());
        return new ArrayList<ClientId>(clientIds);
    }

    public List<? extends Node<PK, D, F>> getChildNodes() {
        return Arrays.asList(this.backingNode, this.cachingNode);
    }

    public List<? extends PhysicalNode<PK, D, F>> getPhysicalNodes() {
        return this.backingNode.getPhysicalNodes();
    }

    public List<? extends PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        return this.backingNode.getPhysicalNodesForClient(clientName);
    }

    public boolean usesClient(String clientName) {
        return this.cachingNode.usesClient(clientName) || this.backingNode.usesClient(clientName);
    }

    public N getBackingNode() {
        return this.backingNode;
    }

    public N getCachingNode() {
        return this.cachingNode;
    }
}

