/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop.util;

import io.datakernel.eventloop.util.OptimizedSelectedKeysSet;
import java.lang.reflect.Field;
import java.nio.channels.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static Field SELECTED_KEYS_FIELD;
    private static Field PUBLIC_SELECTED_KEYS_FIELD;

    public static boolean tryToOptimizeSelector(Selector selector) {
        OptimizedSelectedKeysSet selectedKeys = new OptimizedSelectedKeysSet();
        try {
            SELECTED_KEYS_FIELD.set(selector, selectedKeys);
            PUBLIC_SELECTED_KEYS_FIELD.set(selector, selectedKeys);
            return true;
        }
        catch (IllegalAccessException e) {
            logger.warn("Failed setting optimized set into selector", (Throwable)e);
            return false;
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("sun.nio.ch.SelectorImpl", false, ClassLoader.getSystemClassLoader());
            SELECTED_KEYS_FIELD = cls.getDeclaredField("selectedKeys");
            PUBLIC_SELECTED_KEYS_FIELD = cls.getDeclaredField("publicSelectedKeys");
            SELECTED_KEYS_FIELD.setAccessible(true);
            PUBLIC_SELECTED_KEYS_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            logger.warn("Failed reflecting NIO selector fields", (Throwable)e);
        }
    }
}

