/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop.util;

import io.datakernel.common.Preconditions;
import io.datakernel.common.collection.CollectionUtils;
import io.datakernel.common.exception.UncheckedException;
import io.datakernel.common.ref.RefBoolean;
import io.datakernel.eventloop.jmx.JmxRefreshableStats;
import io.datakernel.eventloop.jmx.JmxStats;
import io.datakernel.eventloop.jmx.JmxStatsWithReset;
import io.datakernel.eventloop.jmx.JmxStatsWithSmoothingWindow;
import io.datakernel.jmx.api.JmxAttribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MXBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    public static boolean isPrimitiveType(Class<?> cls) {
        return cls == Boolean.TYPE || cls == Byte.TYPE || cls == Character.TYPE || cls == Short.TYPE || cls == Integer.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE;
    }

    public static boolean isBoxedPrimitiveType(Class<?> cls) {
        return cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class;
    }

    public static boolean isPrimitiveTypeOrBox(Class<?> cls) {
        return ReflectionUtils.isPrimitiveType(cls) || ReflectionUtils.isBoxedPrimitiveType(cls);
    }

    public static boolean isSimpleType(Class<?> cls) {
        return ReflectionUtils.isPrimitiveTypeOrBox(cls) || cls == String.class;
    }

    public static boolean isThrowable(Class<?> cls) {
        return Throwable.class.isAssignableFrom(cls);
    }

    public static boolean isJmxStats(Class<?> cls) {
        return JmxStats.class.isAssignableFrom(cls);
    }

    public static boolean isJmxRefreshableStats(Class<?> cls) {
        return JmxRefreshableStats.class.isAssignableFrom(cls);
    }

    public static boolean isGetter(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().length() > 2 && (method.getName().startsWith("get") && method.getReturnType() != Void.TYPE || method.getName().startsWith("is") && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class));
    }

    public static boolean isSetter(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().length() > 3 && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterCount() == 1;
    }

    public static String extractFieldNameFromGetter(Method getter) {
        if (getter.getName().startsWith("get")) {
            if (getter.getName().length() == 3) {
                return "";
            }
            String getterName = getter.getName();
            String firstLetter = getterName.substring(3, 4);
            String restOfName = getterName.substring(4);
            return firstLetter.toLowerCase() + restOfName;
        }
        if (getter.getName().startsWith("is") && getter.getName().length() > 2) {
            String getterName = getter.getName();
            String firstLetter = getterName.substring(2, 3);
            String restOfName = getterName.substring(3);
            return firstLetter.toLowerCase() + restOfName;
        }
        throw new IllegalArgumentException("Given method is not a getter");
    }

    public static String extractFieldNameFromSetter(Method setter) {
        String name = setter.getName();
        Preconditions.checkArgument((name.startsWith("set") && name.length() > 3 ? 1 : 0) != 0, (Object)"Given method is not a setter");
        String firstLetter = name.substring(3, 4);
        String restOfName = name.substring(4);
        return firstLetter.toLowerCase() + restOfName;
    }

    @Nullable
    private static <T> Supplier<T> getConstructorOrFactory(Class<T> cls, String ... factoryMethodNames) {
        for (String methodName : factoryMethodNames) {
            Method method;
            try {
                method = cls.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if ((method.getModifiers() & 9) == 0 || method.getReturnType() != cls) continue;
            return () -> {
                try {
                    return method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new UncheckedException((Throwable)e);
                }
            };
        }
        return Arrays.stream(cls.getConstructors()).filter(c -> c.getParameterTypes().length == 0).findAny().map(c -> () -> {
            try {
                return c.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new UncheckedException((Throwable)e);
            }
        }).orElse(null);
    }

    public static boolean canBeCreated(Class<?> cls, String ... factoryMethodNames) {
        return ReflectionUtils.getConstructorOrFactory(cls, factoryMethodNames) != null;
    }

    @Nullable
    public static <T> T tryToCreateInstanceWithFactoryMethods(Class<T> cls, String ... factoryMethodNames) {
        try {
            Supplier<T> supplier = ReflectionUtils.getConstructorOrFactory(cls, factoryMethodNames);
            return supplier != null ? (T)supplier.get() : null;
        }
        catch (UncheckedException u) {
            return null;
        }
    }

    private static void visitFields(Object instance, Predicate<Object> action) {
        if (instance == null) {
            return;
        }
        for (Method method : instance.getClass().getMethods()) {
            Object fieldValue;
            Class<?> returnType;
            if (method.getParameters().length != 0 || !Modifier.isPublic(method.getModifiers()) || (returnType = method.getReturnType()) == Void.TYPE || ReflectionUtils.isSimpleType(returnType) || Arrays.stream(method.getAnnotations()).noneMatch(a -> a.annotationType() == JmxAttribute.class)) continue;
            try {
                fieldValue = method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                continue;
            }
            if (fieldValue == null || action.test(fieldValue)) continue;
            if (Map.class.isAssignableFrom(returnType)) {
                for (Object item : ((Map)fieldValue).values()) {
                    ReflectionUtils.visitFields(item, action);
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                for (Object item : (Collection)fieldValue) {
                    ReflectionUtils.visitFields(item, action);
                }
                continue;
            }
            ReflectionUtils.visitFields(fieldValue, action);
        }
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ReflectionUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, Set<Class<?>> found) {
        while (cls != null) {
            if (cls.isInterface()) {
                found.add(cls);
            }
            for (Class<?> interfaceCls : cls.getInterfaces()) {
                if (!found.add(interfaceCls)) continue;
                ReflectionUtils.getAllInterfaces(interfaceCls, found);
            }
            cls = cls.getSuperclass();
        }
    }

    private static boolean isBeanInterface(Class<?> cls) {
        String name = cls.getName();
        return name.endsWith("MBean") || name.endsWith("MXBean") || cls.isAnnotationPresent(MXBean.class);
    }

    public static boolean isBean(Class<?> cls) {
        return ReflectionUtils.getAllInterfaces(cls).stream().anyMatch(ReflectionUtils::isBeanInterface);
    }

    public static Map<String, Object> getJmxAttributes(@Nullable Object instance) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ReflectionUtils.getJmxAttributes(instance, "", result);
        return result;
    }

    private static boolean getJmxAttributes(@Nullable Object instance, String rootName, Map<String, Object> attrs) {
        if (instance == null) {
            return false;
        }
        Set attributeNames = ReflectionUtils.getAllInterfaces(instance.getClass()).stream().filter(ReflectionUtils::isBeanInterface).flatMap(i -> Arrays.stream(i.getMethods()).filter(ReflectionUtils::isGetter).map(Method::getName)).collect(Collectors.toSet());
        RefBoolean changed = new RefBoolean(false);
        Arrays.stream(instance.getClass().getMethods()).filter(method -> ReflectionUtils.isGetter(method) && (attributeNames.contains(method.getName()) || Arrays.stream(method.getAnnotations()).anyMatch(a -> a.annotationType() == JmxAttribute.class))).sorted(Comparator.comparing(Method::getName)).forEach(method -> {
            String name;
            Object fieldValue;
            method.setAccessible(true);
            try {
                fieldValue = method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return;
            }
            changed.set(true);
            JmxAttribute annotation = method.getAnnotation(JmxAttribute.class);
            String string = name = annotation == null || annotation.name().equals("_USE_GETTER_NAME_") ? ReflectionUtils.extractFieldNameFromGetter(method) : annotation.name();
            String string2 = rootName.isEmpty() ? name : (name = rootName + (name.isEmpty() ? "" : "_" + name));
            if (fieldValue != instance && !attrs.containsKey(name) && !ReflectionUtils.getJmxAttributes(fieldValue, name, attrs)) {
                attrs.put(name, fieldValue);
            }
        });
        return changed.get();
    }

    public static void resetStats(Object instance) {
        ReflectionUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithReset) {
                ((JmxStatsWithReset)item).resetStats();
                return true;
            }
            return false;
        });
    }

    public static void setSmoothingWindow(Object instance, Duration smoothingWindowSeconds) {
        ReflectionUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithSmoothingWindow) {
                ((JmxStatsWithSmoothingWindow)item).setSmoothingWindow(smoothingWindowSeconds);
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static Duration getSmoothingWindow(Object instance) {
        HashSet result = new HashSet();
        ReflectionUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithSmoothingWindow) {
                Duration smoothingWindow = ((JmxStatsWithSmoothingWindow)item).getSmoothingWindow();
                result.add(smoothingWindow);
                return true;
            }
            return false;
        });
        if (result.size() == 1) {
            return (Duration)CollectionUtils.first(result);
        }
        return null;
    }

    public static String getAnnotationString(@NotNull Class<? extends Annotation> annotationType, @Nullable Annotation annotation) throws ReflectiveOperationException {
        if (annotation != null) {
            return ReflectionUtils.getAnnotationString(annotation);
        }
        return annotationType.getSimpleName();
    }

    public static String getAnnotationString(Annotation annotation) throws ReflectiveOperationException {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        StringBuilder annotationString = new StringBuilder();
        Method[] annotationElements = ReflectionUtils.filterNonEmptyElements(annotation);
        if (annotationElements.length == 0) {
            annotationString.append(annotationType.getSimpleName());
            return annotationString.toString();
        }
        if (annotationElements.length == 1 && annotationElements[0].getName().equals("value")) {
            annotationString.append(annotationType.getSimpleName());
            Object value = ReflectionUtils.fetchAnnotationElementValue(annotation, annotationElements[0]);
            annotationString.append('(').append(value.toString()).append(')');
            return annotationString.toString();
        }
        annotationString.append('(');
        for (Method annotationParameter : annotationElements) {
            Object value = ReflectionUtils.fetchAnnotationElementValue(annotation, annotationParameter);
            String nameKey = annotationParameter.getName();
            String nameValue = value.toString();
            annotationString.append(nameKey).append('=').append(nameValue).append(',');
        }
        assert (annotationString.substring(annotationString.length() - 1).equals(","));
        annotationString = new StringBuilder(annotationString.substring(0, annotationString.length() - 1));
        annotationString.append(')');
        return annotationString.toString();
    }

    public static Method[] filterNonEmptyElements(Annotation annotation) throws ReflectiveOperationException {
        ArrayList<Method> filtered = new ArrayList<Method>();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            String stringValue;
            Object elementValue = ReflectionUtils.fetchAnnotationElementValue(annotation, method);
            if (elementValue instanceof String && (stringValue = (String)elementValue).length() == 0) continue;
            filtered.add(method);
        }
        return filtered.toArray(new Method[0]);
    }

    public static Object fetchAnnotationElementValue(Annotation annotation, Method element) throws ReflectiveOperationException {
        Object value = element.invoke((Object)annotation, new Object[0]);
        if (value == null) {
            String errorMsg = "@" + annotation.annotationType().getName() + "." + element.getName() + "() returned null";
            throw new NullPointerException(errorMsg);
        }
        return value;
    }

    public static boolean isPrivateApiAvailable() {
        try {
            Class.forName("java.lang.Module");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }
}

