/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop.util;

import java.nio.channels.SelectionKey;
import java.util.AbstractSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptimizedSelectedKeysSet
extends AbstractSet<SelectionKey> {
    private static final int INITIAL_SIZE = 16;
    private int size;
    private SelectionKey[] selectionKeys;

    public OptimizedSelectedKeysSet() {
        this.selectionKeys = new SelectionKey[16];
    }

    public OptimizedSelectedKeysSet(int initialSize) {
        this.selectionKeys = new SelectionKey[initialSize];
    }

    @Override
    public boolean add(SelectionKey selectionKey) {
        this.ensureCapacity();
        this.selectionKeys[this.size++] = selectionKey;
        return true;
    }

    private void ensureCapacity() {
        if (this.size < this.selectionKeys.length) {
            return;
        }
        SelectionKey[] newArray = new SelectionKey[this.selectionKeys.length * 2];
        System.arraycopy(this.selectionKeys, 0, newArray, 0, this.size);
        this.selectionKeys = newArray;
    }

    @Nullable
    public SelectionKey get(int index) {
        if (index >= 0 && index < this.size) {
            return this.selectionKeys[index];
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<SelectionKey> iterator() {
        return new Iterator<SelectionKey>(){
            int step;

            @Override
            public boolean hasNext() {
                return this.step < OptimizedSelectedKeysSet.this.size;
            }

            @Override
            public SelectionKey next() {
                return OptimizedSelectedKeysSet.this.selectionKeys[this.step++];
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }
}

