/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop.net;

import io.datakernel.common.MemSize;
import io.datakernel.common.Preconditions;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import org.jetbrains.annotations.NotNull;

public final class ServerSocketSettings {
    public static final int DEFAULT_BACKLOG = 16384;
    private static final byte DEF_BOOL = -1;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private final int backlog;
    private final int receiveBufferSize;
    private final byte reuseAddress;

    private ServerSocketSettings(int backlog, int receiveBufferSize, byte reuseAddress) {
        this.backlog = backlog;
        this.receiveBufferSize = receiveBufferSize;
        this.reuseAddress = reuseAddress;
    }

    public static ServerSocketSettings create(int backlog) {
        return new ServerSocketSettings(backlog, 0, -1);
    }

    public ServerSocketSettings withBacklog(int backlog) {
        return new ServerSocketSettings(backlog, this.receiveBufferSize, this.reuseAddress);
    }

    public ServerSocketSettings withReceiveBufferSize(@NotNull MemSize receiveBufferSize) {
        return new ServerSocketSettings(this.backlog, receiveBufferSize.toInt(), this.reuseAddress);
    }

    public ServerSocketSettings withReuseAddress(boolean reuseAddress) {
        return new ServerSocketSettings(this.backlog, this.receiveBufferSize, reuseAddress ? (byte)1 : 0);
    }

    public void applySettings(@NotNull ServerSocketChannel channel) throws IOException {
        if (this.receiveBufferSize != 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize);
        }
        if (this.reuseAddress != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)(this.reuseAddress != 0 ? 1 : 0));
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != 0;
    }

    @NotNull
    public MemSize getReceiveBufferSize() {
        return MemSize.of((long)this.getReceiveBufferSizeBytes());
    }

    public int getReceiveBufferSizeBytes() {
        Preconditions.check((boolean)this.hasReceiveBufferSize(), (Object)"No 'receive buffer size' setting is present");
        return this.receiveBufferSize;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != -1;
    }

    public boolean getReuseAddress() {
        Preconditions.check((boolean)this.hasReuseAddress(), (Object)"No 'reuse address' setting is present");
        return this.reuseAddress != 0;
    }
}

