/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop.jmx;

import io.datakernel.common.Preconditions;
import io.datakernel.eventloop.jmx.EventStats;
import io.datakernel.eventloop.jmx.JmxRefreshableStats;
import io.datakernel.eventloop.jmx.JmxStatsWithReset;
import io.datakernel.eventloop.jmx.JmxStatsWithSmoothingWindow;
import io.datakernel.jmx.api.JmxAttribute;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ValueStats
implements JmxRefreshableStats<ValueStats>,
JmxStatsWithReset,
JmxStatsWithSmoothingWindow {
    private static final long TOO_LONG_TIME_PERIOD_BETWEEN_REFRESHES = Duration.ofHours(1L).toMillis();
    private static final double LN_2 = Math.log(2.0);
    public static final int[] POWERS_OF_TWO = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
    public static final int[] POWERS_OF_TEN = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int[] POWERS_OF_TEN_SHORTENED = new int[]{0, 1, 10, 100, 1000};
    public static final int[] POWERS_OF_TEN_SEMI_LINEAR = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000, 10000000, 20000000, 30000000, 40000000, 50000000, 60000000, 70000000, 80000000, 90000000, 100000000, 200000000, 300000000, 400000000, 500000000, 600000000, 700000000, 800000000, 900000000, 1000000000, 2000000000};
    public static final int[] POWERS_OF_TEN_SEMI_LINEAR_1000 = new int[]{0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000, 10000000, 20000000, 30000000, 40000000, 50000000, 60000000, 70000000, 80000000, 90000000, 100000000, 200000000, 300000000, 400000000, 500000000, 600000000, 700000000, 800000000, 900000000, 1000000000, 2000000000};
    private long lastTimestampMillis;
    private int lastValueInteger;
    private int lastSumInteger;
    private int lastSqrInteger;
    private int lastCountInteger;
    private int lastMinInteger;
    private int lastMaxInteger;
    private double lastValueDouble;
    private double lastSumDouble;
    private double lastSqrDouble;
    private int lastCountDouble;
    private double lastMinDouble;
    private double lastMaxDouble;
    private double totalSum;
    private long totalCount;
    private double smoothedSum;
    private double smoothedSqr;
    private double smoothedCount;
    private double smoothedMin;
    private double smoothedMax;
    private double absoluteMaxValue;
    private double absoluteMinValue;
    private double smoothedTimeSeconds;
    private double smoothedRate;
    private double smoothingWindow;
    private double smoothingWindowCoef;
    private int[] histogramLevels;
    private long[] histogramValues;
    private int addedStats;
    @Nullable
    private String unit;
    @Nullable
    private String rateUnit;
    private boolean useAvgAndDeviaton = true;
    private boolean useMinMax = true;
    private boolean useLastValue = true;
    private boolean useAbsoluteValues;
    private int precision = 1000;

    private ValueStats(double smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
        this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(smoothingWindow);
        this.resetStats();
    }

    private ValueStats() {
        this.smoothingWindow = -1.0;
        this.smoothingWindowCoef = -1.0;
    }

    public static ValueStats createAccumulator() {
        return new ValueStats();
    }

    public static ValueStats create(Duration smoothingWindow) {
        return new ValueStats((double)smoothingWindow.toMillis() / 1000.0);
    }

    public ValueStats withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public ValueStats withRate(String rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public ValueStats withRate() {
        this.rateUnit = "";
        return this;
    }

    public ValueStats withHistogram(int[] levels) {
        this.setHistogramLevels(levels);
        return this;
    }

    public ValueStats withAbsoluteValues(boolean value) {
        this.useAbsoluteValues = value;
        return this;
    }

    public ValueStats withAverageAndDeviation(boolean value) {
        this.useAvgAndDeviaton = value;
        return this;
    }

    public ValueStats withMinMax(boolean value) {
        this.useMinMax = value;
        return this;
    }

    public ValueStats withLastValue(boolean value) {
        this.useLastValue = value;
        return this;
    }

    public ValueStats withPrecision(int precision) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Precision should be a positive value");
        this.precision = precision;
        return this;
    }

    public ValueStats withScientificNotation() {
        this.precision = -1;
        return this;
    }

    public void setHistogramLevels(int[] levels) {
        Preconditions.checkArgument((levels.length > 0 ? 1 : 0) != 0, (Object)"levels amount must be at least 1");
        for (int i = 1; i < levels.length; ++i) {
            Preconditions.checkArgument((levels[i] > levels[i - 1] ? 1 : 0) != 0, (Object)"levels must be ascending");
        }
        this.histogramLevels = levels;
        this.histogramValues = new long[levels.length + 1];
    }

    @Override
    public void resetStats() {
        this.smoothedSum = 0.0;
        this.smoothedSqr = 0.0;
        this.smoothedCount = 0.0;
        this.smoothedMin = 0.0;
        this.smoothedMax = 0.0;
        this.lastMaxInteger = Integer.MIN_VALUE;
        this.lastMinInteger = Integer.MAX_VALUE;
        this.lastSumInteger = 0;
        this.lastSqrInteger = 0;
        this.lastCountInteger = 0;
        this.lastValueInteger = 0;
        this.lastMaxDouble = -1.7976931348623157E308;
        this.lastMinDouble = Double.MAX_VALUE;
        this.lastSumDouble = 0.0;
        this.lastSqrDouble = 0.0;
        this.lastCountDouble = 0;
        this.lastValueDouble = 0.0;
        this.lastTimestampMillis = 0L;
        this.smoothedRate = 0.0;
        this.smoothedTimeSeconds = 0.0;
        this.totalSum = 0.0;
        this.totalCount = 0L;
        if (this.histogramLevels != null) {
            for (int i = 0; i < this.histogramValues.length; ++i) {
                this.histogramValues[i] = 0L;
            }
        }
    }

    public void recordValue(int value) {
        this.lastValueInteger = value;
        if (value < this.lastMinInteger) {
            this.lastMinInteger = value;
        }
        if (value > this.lastMaxInteger) {
            this.lastMaxInteger = value;
        }
        this.lastSumInteger += value;
        this.lastSqrInteger += value * value;
        ++this.lastCountInteger;
        if (this.histogramLevels != null) {
            this.addToHistogram(value);
        }
    }

    public void recordValue(double value) {
        this.lastValueDouble = value;
        if (value < this.lastMinDouble) {
            this.lastMinDouble = value;
        }
        if (value > this.lastMaxDouble) {
            this.lastMaxDouble = value;
        }
        this.lastSumDouble += value;
        this.lastSqrDouble += value * value;
        ++this.lastCountDouble;
    }

    private void addToHistogram(int value) {
        if (this.histogramLevels == POWERS_OF_TWO) {
            this.addToPow2Histogram(value);
        } else if (value >= this.histogramLevels[this.histogramLevels.length - 1]) {
            int n = this.histogramValues.length - 1;
            this.histogramValues[n] = this.histogramValues[n] + 1L;
        } else {
            int bucketIndex = this.histogramLevels.length <= 6 ? ValueStats.linearSearch(this.histogramLevels, value) : ValueStats.binarySearch(this.histogramLevels, value);
            int n = bucketIndex;
            this.histogramValues[n] = this.histogramValues[n] + 1L;
        }
    }

    private void addToPow2Histogram(int value) {
        if (value < 0) {
            this.histogramValues[0] = this.histogramValues[0] + 1L;
        } else {
            int n = 33 - Integer.numberOfLeadingZeros(value);
            this.histogramValues[n] = this.histogramValues[n] + 1L;
        }
    }

    private static int linearSearch(int[] histogramLevels, int value) {
        for (int i = 0; i < histogramLevels.length; ++i) {
            if (value >= histogramLevels[i]) continue;
            return i;
        }
        return histogramLevels.length;
    }

    private static int binarySearch(int[] arr, int value) {
        int found = 0;
        int left = 0;
        int right = arr.length - 1;
        while (left < right) {
            if (right - left == 1) {
                found = value < arr[left] ? left : right;
                break;
            }
            int middle = left + (right - left) / 2;
            if (value < arr[middle]) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return found;
    }

    @Override
    public void refresh(long timestamp) {
        double lastSum = 0.0;
        double lastSqr = 0.0;
        long lastCount = 0L;
        if (this.lastCountDouble > 0) {
            lastSum += this.lastSumDouble;
            lastSqr += this.lastSqrDouble;
            lastCount += (long)this.lastCountDouble;
        }
        if (this.lastCountInteger > 0) {
            lastSum += (double)this.lastSumInteger;
            lastSqr += (double)this.lastSqrInteger;
            lastCount += (long)this.lastCountInteger;
        }
        double lastMin = (double)this.lastMinInteger < this.lastMinDouble ? (double)this.lastMinInteger : this.lastMinDouble;
        double lastMax = (double)this.lastMaxInteger > this.lastMaxDouble ? (double)this.lastMaxInteger : this.lastMaxDouble;
        this.absoluteMinValue = this.absoluteMinValue < lastMin ? this.absoluteMinValue : lastMin;
        double d = this.absoluteMaxValue = this.absoluteMaxValue > lastMax ? this.absoluteMaxValue : lastMax;
        if (this.lastTimestampMillis == 0L) {
            this.smoothedSum = lastSum;
            this.smoothedSqr = lastSqr;
            this.smoothedCount = lastCount;
            this.totalSum = lastSum;
            this.totalCount = lastCount;
            this.smoothedMin = lastMin;
            this.smoothedMax = lastMax;
        } else {
            long timeElapsedMillis = timestamp - this.lastTimestampMillis;
            if (ValueStats.isTimePeriodValid(timeElapsedMillis)) {
                double timeElapsedSeconds = (double)timeElapsedMillis * 0.001;
                double smoothingFactor = Math.exp(timeElapsedSeconds * this.smoothingWindowCoef);
                this.smoothedSum = lastSum + this.smoothedSum * smoothingFactor;
                this.smoothedSqr = lastSqr + this.smoothedSqr * smoothingFactor;
                this.smoothedCount = (double)lastCount + this.smoothedCount * smoothingFactor;
                this.smoothedTimeSeconds = timeElapsedSeconds + this.smoothedTimeSeconds * smoothingFactor;
                this.smoothedRate = this.smoothedCount / this.smoothedTimeSeconds;
                this.totalSum += lastSum;
                this.totalCount += lastCount;
                if (lastCount != 0L) {
                    this.smoothedMin += (this.smoothedMax - this.smoothedMin) * (1.0 - smoothingFactor);
                    this.smoothedMax += (this.smoothedMin - this.smoothedMax) * (1.0 - smoothingFactor);
                    if (lastMin < this.smoothedMin) {
                        this.smoothedMin = lastMin;
                    }
                    if (lastMax > this.smoothedMax) {
                        this.smoothedMax = lastMax;
                    }
                }
            }
        }
        this.lastTimestampMillis = timestamp;
        if (this.lastCountInteger > 0) {
            this.lastSumInteger = 0;
            this.lastSqrInteger = 0;
            this.lastCountInteger = 0;
            this.lastMinInteger = Integer.MAX_VALUE;
            this.lastMaxInteger = Integer.MIN_VALUE;
        }
        if (this.lastCountDouble > 0) {
            this.lastSumDouble = 0.0;
            this.lastSqrDouble = 0.0;
            this.lastCountDouble = 0;
            this.lastMinDouble = Double.MAX_VALUE;
            this.lastMaxDouble = -1.7976931348623157E308;
        }
    }

    private static boolean isTimePeriodValid(long timePeriod) {
        return timePeriod < TOO_LONG_TIME_PERIOD_BETWEEN_REFRESHES && timePeriod > 0L;
    }

    @Override
    public void add(ValueStats anotherStats) {
        if (anotherStats.lastTimestampMillis == 0L) {
            return;
        }
        this.smoothedSum += anotherStats.smoothedSum;
        this.smoothedSqr += anotherStats.smoothedSqr;
        this.smoothedCount += anotherStats.smoothedCount;
        this.smoothedRate += anotherStats.smoothedRate;
        this.totalSum += anotherStats.totalSum;
        this.totalCount += anotherStats.totalCount;
        if (this.addedStats == 0) {
            this.smoothedMin = anotherStats.smoothedMin;
            this.smoothedMax = anotherStats.smoothedMax;
        } else {
            if (anotherStats.smoothedMin < this.smoothedMin) {
                this.smoothedMin = anotherStats.smoothedMin;
            }
            if (anotherStats.smoothedMax > this.smoothedMax) {
                this.smoothedMax = anotherStats.smoothedMax;
            }
        }
        if (anotherStats.lastTimestampMillis > this.lastTimestampMillis) {
            this.lastTimestampMillis = anotherStats.lastTimestampMillis;
            this.lastValueInteger = anotherStats.lastValueInteger;
            this.lastValueDouble = anotherStats.lastValueDouble;
        }
        if (this.addedStats == 0) {
            this.smoothingWindow = anotherStats.smoothingWindow;
            this.smoothingWindowCoef = anotherStats.smoothingWindowCoef;
        } else if (this.smoothingWindow != anotherStats.smoothingWindow) {
            this.smoothingWindow = -1.0;
            this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(this.smoothingWindow);
        }
        if (this.addedStats == 0) {
            if (anotherStats.histogramLevels != null) {
                this.histogramLevels = Arrays.copyOf(anotherStats.histogramLevels, anotherStats.histogramLevels.length);
                this.histogramValues = Arrays.copyOf(anotherStats.histogramValues, anotherStats.histogramValues.length);
            }
        } else if (this.histogramLevels != null) {
            for (int i = 0; i < this.histogramValues.length; ++i) {
                int n = i;
                this.histogramValues[n] = this.histogramValues[n] + anotherStats.histogramValues[i];
            }
        }
        ++this.addedStats;
    }

    private static double calculateSmoothingWindowCoef(double smoothingWindow) {
        return -(LN_2 / smoothingWindow);
    }

    @JmxAttribute(optional=true)
    public double getLastValue() {
        return this.lastCountInteger > this.lastCountDouble ? (double)this.lastValueInteger : this.lastValueDouble;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedAverage() {
        if (this.totalCount == 0L) {
            return 0.0;
        }
        return this.smoothedSum / this.smoothedCount;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedStandardDeviation() {
        if (this.totalCount == 0L) {
            return 0.0;
        }
        double avg = this.smoothedSum / this.smoothedCount;
        double variance = this.smoothedSqr / this.smoothedCount - avg * avg;
        if (variance < 0.0) {
            variance = 0.0;
        }
        return Math.sqrt(variance);
    }

    @JmxAttribute(name="min", optional=true)
    public double getSmoothedMin() {
        return this.totalCount == 0L ? 0.0 : this.smoothedMin;
    }

    @JmxAttribute(name="max", optional=true)
    public double getSmoothedMax() {
        return this.totalCount == 0L ? 0.0 : this.smoothedMax;
    }

    @JmxAttribute(name="absoluteMin", optional=true)
    public double getAbsosuteMin() {
        return this.totalCount == 0L ? 0.0 : this.absoluteMinValue;
    }

    @JmxAttribute(name="absoluteMax", optional=true)
    public double getAbsoluteMax() {
        return this.totalCount == 0L ? 0.0 : this.absoluteMaxValue;
    }

    @JmxAttribute(optional=true)
    public double getAverage() {
        return this.totalCount != 0L ? this.totalSum / (double)this.totalCount : 0.0;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedRate() {
        return this.smoothedRate;
    }

    @Override
    @JmxAttribute(optional=true)
    public Duration getSmoothingWindow() {
        return Duration.ofMillis((long)(this.smoothingWindow * 1000.0));
    }

    @Override
    @JmxAttribute(optional=true)
    public void setSmoothingWindow(Duration smoothingWindow) {
        this.smoothingWindow = (double)smoothingWindow.toMillis() / 1000.0;
        this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(this.smoothingWindow);
    }

    @JmxAttribute(optional=true)
    public long getCount() {
        return this.totalCount;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public List<String> getHistogram() {
        if (this.histogramLevels == null) {
            return null;
        }
        if (!this.histogramContainsValues()) {
            return null;
        }
        int left = this.findLeftHistogramLimit();
        int right = this.findRightHistogramLimit();
        String[] lines = new String[right - left + 1];
        String[] labels = ValueStats.createHistogramLabels(this.histogramLevels, left, right - 1);
        long[] values = Arrays.copyOfRange(this.histogramValues, left, right + 1);
        int maxValueStrLen = 0;
        for (long value : this.histogramValues) {
            String valueStr = Long.toString(value);
            if (valueStr.length() <= maxValueStrLen) continue;
            maxValueStrLen = valueStr.length();
        }
        String pattern = "  :  %" + maxValueStrLen + "s";
        for (int i = 0; i < values.length; ++i) {
            lines[i] = labels[i] + String.format(pattern, values[i]);
        }
        return Arrays.asList(lines);
    }

    private boolean histogramContainsValues() {
        if (this.histogramValues == null) {
            return false;
        }
        for (long value : this.histogramValues) {
            if (value == 0L) continue;
            return true;
        }
        return false;
    }

    private int findLeftHistogramLimit() {
        int left = 0;
        for (int i = 0; i < this.histogramValues.length; ++i) {
            if (this.histogramValues[i] == 0L) continue;
            left = i;
            break;
        }
        left = left > 0 ? left - 1 : left;
        return left;
    }

    private int findRightHistogramLimit() {
        int right = this.histogramValues.length - 1;
        for (int i = this.histogramValues.length - 1; i >= 0; --i) {
            if (this.histogramValues[i] == 0L) continue;
            right = i;
            break;
        }
        right = right < this.histogramValues.length - 1 ? right + 1 : right;
        return right;
    }

    private static String[] createHistogramLabels(int[] levels, int left, int right) {
        int maxLevelStrLen = 0;
        for (int i = left; i <= right; ++i) {
            String levelStr = Integer.toString(levels[i]);
            if (levelStr.length() <= maxLevelStrLen) continue;
            maxLevelStrLen = levelStr.length();
        }
        String negInf = "-\u221e";
        String posInf = "+\u221e";
        int maxLeftSymbols = Math.max(negInf.length(), maxLevelStrLen);
        int maxRightSymbols = Math.max(posInf.length(), maxLevelStrLen);
        String pattern = "%" + maxLeftSymbols + "s, %" + maxRightSymbols + "s";
        ArrayList<String> labels = new ArrayList<String>(right - left + 1 + 2);
        labels.add("(" + String.format(pattern, negInf, levels[left]) + ")");
        for (int i = left + 1; i <= right; ++i) {
            labels.add("[" + String.format(pattern, levels[i - 1], levels[i]) + ")");
        }
        labels.add("[" + String.format(pattern, levels[right], posInf) + ")");
        return labels.toArray(new String[0]);
    }

    @JmxAttribute
    public String get() {
        return this.toString();
    }

    public String toString() {
        DecimalFormat decimalFormat;
        if (this.totalCount == 0L) {
            return "<totalCount is 0>";
        }
        double min = this.smoothedMin;
        double max = this.smoothedMax;
        if (this.useAbsoluteValues) {
            min = this.absoluteMinValue;
            max = this.absoluteMaxValue;
        }
        if (this.precision == -1) {
            decimalFormat = new DecimalFormat("0.0####E0#");
        } else {
            decimalFormat = new DecimalFormat("0");
            decimalFormat.setMaximumFractionDigits((int)Math.ceil(Math.min(Math.max(-Math.log10(Math.abs(max - min) / (double)this.precision), 0.0), 6.0)));
        }
        StringBuilder constructorTemplate = new StringBuilder();
        if (this.useAvgAndDeviaton) {
            constructorTemplate.append(decimalFormat.format(this.getSmoothedAverage())).append('\u00b1').append(decimalFormat.format(this.getSmoothedStandardDeviation())).append(' ');
            if (this.unit != null) {
                constructorTemplate.append(this.unit).append("  ");
            } else {
                constructorTemplate.append(' ');
            }
        }
        if (this.useMinMax) {
            constructorTemplate.append('[').append(decimalFormat.format(min)).append("...").append(decimalFormat.format(max)).append("]  ");
        }
        if (this.useLastValue) {
            constructorTemplate.append("last: ").append(decimalFormat.format(this.getLastValue())).append("  ");
        }
        if (this.rateUnit != null) {
            constructorTemplate.append("calls: ").append(EventStats.format(this.totalCount, this.smoothedRate, this.rateUnit, decimalFormat));
        }
        return constructorTemplate.toString().trim();
    }
}

