/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop.jmx;

import io.datakernel.common.Preconditions;
import io.datakernel.eventloop.jmx.JmxRefreshableStats;
import io.datakernel.eventloop.jmx.JmxStatsWithReset;
import io.datakernel.eventloop.jmx.JmxStatsWithSmoothingWindow;
import io.datakernel.jmx.api.JmxAttribute;
import java.text.DecimalFormat;
import java.time.Duration;
import org.jetbrains.annotations.Nullable;

public final class EventStats
implements JmxRefreshableStats<EventStats>,
JmxStatsWithSmoothingWindow,
JmxStatsWithReset {
    private static final long TOO_LONG_TIME_PERIOD_BETWEEN_REFRESHES = Duration.ofHours(1L).toMillis();
    private static final double LN_2 = Math.log(2.0);
    private long lastTimestampMillis;
    private int lastCount;
    private long totalCount;
    private double smoothedCount;
    private double smoothedTimeSeconds;
    private double smoothedRate;
    private double smoothingWindow;
    private double smoothingWindowCoef;
    private int addedStats;
    @Nullable
    private String rateUnit;
    private int precision = 1000;

    private EventStats(double smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
        this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(smoothingWindow);
    }

    private EventStats() {
        this.smoothingWindow = -1.0;
        this.smoothingWindowCoef = -1.0;
    }

    public static EventStats createAccumulator() {
        return new EventStats();
    }

    public static EventStats create(Duration smoothingWindow) {
        return new EventStats((double)smoothingWindow.toMillis() / 1000.0);
    }

    public EventStats withRateUnit(String rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public EventStats withPrecision(int precision) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Precision should be a positive value");
        this.precision = precision;
        return this;
    }

    public EventStats withScientificNotation() {
        this.precision = -1;
        return this;
    }

    private static double calculateSmoothingWindowCoef(double smoothingWindow) {
        return -(LN_2 / smoothingWindow);
    }

    @Override
    public void resetStats() {
        this.lastCount = 0;
        this.totalCount = 0L;
        this.lastTimestampMillis = 0L;
        this.smoothedCount = 0.0;
        this.smoothedRate = 0.0;
        this.smoothedTimeSeconds = 0.0;
    }

    public void recordEvent() {
        ++this.lastCount;
    }

    public void recordEvents(int events) {
        this.lastCount += events;
    }

    @Override
    public void refresh(long timestamp) {
        long timeElapsedMillis = timestamp - this.lastTimestampMillis;
        if (EventStats.isTimePeriodValid(timeElapsedMillis)) {
            double timeElapsedSeconds = (double)timeElapsedMillis * 0.001;
            double smoothingFactor = Math.exp(timeElapsedSeconds * this.smoothingWindowCoef);
            this.smoothedCount = (double)this.lastCount + this.smoothedCount * smoothingFactor;
            this.smoothedTimeSeconds = timeElapsedSeconds + this.smoothedTimeSeconds * smoothingFactor;
            this.smoothedRate = this.smoothedCount / this.smoothedTimeSeconds;
        }
        this.totalCount += (long)this.lastCount;
        this.lastCount = 0;
        this.lastTimestampMillis = timestamp;
    }

    private static boolean isTimePeriodValid(long timePeriod) {
        return timePeriod < TOO_LONG_TIME_PERIOD_BETWEEN_REFRESHES && timePeriod > 0L;
    }

    @Override
    public void add(EventStats anotherStats) {
        this.totalCount += anotherStats.totalCount;
        this.smoothedCount += anotherStats.smoothedCount;
        this.smoothedRate += anotherStats.smoothedRate;
        if (this.addedStats == 0) {
            this.smoothingWindow = anotherStats.smoothingWindow;
            this.smoothingWindowCoef = anotherStats.smoothingWindowCoef;
        } else if (this.smoothingWindow != anotherStats.smoothingWindow) {
            this.smoothingWindow = -1.0;
            this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(this.smoothingWindow);
        }
        ++this.addedStats;
    }

    public static String format(long count, double rate, String rateUnit, DecimalFormat decimalFormat) {
        return count + " @ " + decimalFormat.format(rate) + (rateUnit == null || rateUnit.equals("") ? "" : " " + rateUnit) + "/second";
    }

    @JmxAttribute(optional=true)
    public double getSmoothedRate() {
        return this.smoothedRate;
    }

    @JmxAttribute(optional=true)
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    @JmxAttribute(optional=true)
    public Duration getSmoothingWindow() {
        return Duration.ofMillis((long)(this.smoothingWindow * 1000.0));
    }

    @Override
    @JmxAttribute(optional=true)
    public void setSmoothingWindow(Duration smoothingWindow) {
        this.smoothingWindow = (double)smoothingWindow.toMillis() / 1000.0;
        this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(this.smoothingWindow);
    }

    @JmxAttribute
    public String get() {
        return this.toString();
    }

    public String toString() {
        DecimalFormat decimalFormat;
        if (this.totalCount == 0L) {
            return null;
        }
        if (this.precision == -1) {
            decimalFormat = new DecimalFormat("0.0####E0#");
        } else {
            decimalFormat = new DecimalFormat("0");
            decimalFormat.setMaximumFractionDigits((int)Math.ceil(Math.min(Math.max(-Math.log10(Math.abs(this.smoothedRate) / (double)this.precision), 0.0), 6.0)));
        }
        return EventStats.format(this.totalCount, this.smoothedRate, this.rateUnit, decimalFormat);
    }
}

