/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.common.Preconditions;
import io.datakernel.common.Stopwatch;
import io.datakernel.common.inspector.AbstractInspector;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopInspector;
import io.datakernel.eventloop.jmx.EventloopJmxMBean;
import io.datakernel.jmx.api.JmxAttribute;
import io.datakernel.jmx.api.JmxOperation;
import io.datakernel.jmx.api.JmxReducers;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThrottlingController
extends AbstractInspector<EventloopInspector>
implements EventloopJmxMBean,
EventloopInspector {
    private static int staticInstanceCounter = 0;
    private final Logger logger = LoggerFactory.getLogger((String)(ThrottlingController.class.getName() + "." + staticInstanceCounter++));
    public static final Duration TARGET_TIME = Duration.ofMillis(20L);
    public static final Duration GC_TIME = Duration.ofMillis(20L);
    public static final Duration SMOOTHING_WINDOW = Duration.ofSeconds(10L);
    public static final double THROTTLING_DECREASE = 0.1;
    public static final double INITIAL_KEYS_PER_SECOND = 100.0;
    public static final double INITIAL_THROTTLING = 0.0;
    private Eventloop eventloop;
    private int lastSelectedKeys;
    private int concurrentTasksSize;
    private int targetTimeMillis;
    private int gcTimeMillis;
    private double throttlingDecrease;
    private int smoothingWindow;
    private int bufferedRequests;
    private int bufferedRequestsThrottled;
    private double smoothedThrottling;
    private double smoothedTimePerKeyMillis;
    private long infoTotalRequests;
    private long infoTotalRequestsThrottled;
    private long infoTotalTimeMillis;
    private long infoRounds;
    private long infoRoundsZeroThrottling;
    private long infoRoundsExceededTargetTime;
    private long infoRoundsGc;
    private float throttling;
    private static long rngState = System.nanoTime();

    private ThrottlingController() {
    }

    @NotNull
    public static ThrottlingController create(@NotNull Eventloop eventloop) {
        return ThrottlingController.create().withEventloop(eventloop);
    }

    @NotNull
    public static ThrottlingController create() {
        return new ThrottlingController().withTargetTime(TARGET_TIME).withGcTime(GC_TIME).withSmoothingWindow(SMOOTHING_WINDOW).withThrottlingDecrease(0.1).withInitialKeysPerSecond(100.0).withInitialThrottling(0.0);
    }

    @NotNull
    private ThrottlingController withEventloop(@NotNull Eventloop eventloop) {
        this.setEventloop(eventloop);
        return this;
    }

    public void setEventloop(@NotNull Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    @NotNull
    public ThrottlingController withTargetTime(@NotNull Duration targetTime) {
        this.setTargetTime(targetTime);
        return this;
    }

    @NotNull
    public ThrottlingController withGcTime(@NotNull Duration gcTime) {
        this.setGcTime(gcTime);
        return this;
    }

    @NotNull
    public ThrottlingController withSmoothingWindow(@NotNull Duration smoothingWindow) {
        this.setSmoothingWindow(smoothingWindow);
        return this;
    }

    @NotNull
    public ThrottlingController withThrottlingDecrease(double throttlingDecrease) {
        this.setThrottlingDecrease(throttlingDecrease);
        return this;
    }

    @NotNull
    public ThrottlingController withInitialKeysPerSecond(double initialKeysPerSecond) {
        Preconditions.checkArgument((initialKeysPerSecond > 0.0 ? 1 : 0) != 0, (Object)"Initial keys per second should not be zero or less");
        this.smoothedTimePerKeyMillis = 1000.0 / initialKeysPerSecond;
        return this;
    }

    @NotNull
    public ThrottlingController withInitialThrottling(double initialThrottling) {
        Preconditions.checkArgument((initialThrottling >= 0.0 ? 1 : 0) != 0, (Object)"Initial throttling should not be zero or less");
        this.smoothedThrottling = initialThrottling;
        return this;
    }

    private static float nextFloat() {
        long x = rngState;
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        rngState = x;
        return (float)((int)(x &= 0xFFFFFFL)) / 1.6777216E7f;
    }

    public boolean isOverloaded() {
        ++this.bufferedRequests;
        if (ThrottlingController.nextFloat() < this.throttling) {
            ++this.bufferedRequestsThrottled;
            return true;
        }
        return false;
    }

    @Override
    public void onUpdateConcurrentTasksStats(int concurrentTasksSize, long loopTime) {
        this.concurrentTasksSize = concurrentTasksSize;
    }

    @Override
    public void onUpdateSelectedKeysStats(int lastSelectedKeys, int invalidKeys, int acceptKeys, int connectKeys, int readKeys, int writeKeys, long loopTime) {
        this.lastSelectedKeys = lastSelectedKeys;
    }

    @Override
    public void onUpdateBusinessLogicTime(boolean anyTaskOrKeyPresent, boolean externalTaskOrKeyPresent, long businessLogicTime) {
        double value;
        if (businessLogicTime < 0L || businessLogicTime > 60000L) {
            this.logger.warn("Invalid processing time: {}", (Object)businessLogicTime);
            return;
        }
        int throttlingKeys = this.lastSelectedKeys + this.concurrentTasksSize;
        int lastTimePredicted = (int)((double)throttlingKeys * this.smoothedTimePerKeyMillis);
        if ((double)this.gcTimeMillis != 0.0 && businessLogicTime > (long)(lastTimePredicted + this.gcTimeMillis)) {
            this.logger.debug("GC detected {} ms, {} keys", (Object)businessLogicTime, (Object)throttlingKeys);
            businessLogicTime = lastTimePredicted + this.gcTimeMillis;
            ++this.infoRoundsGc;
        }
        double weight = 1.0 - 1.0 / (double)this.smoothingWindow;
        if (this.bufferedRequests != 0) {
            assert (this.bufferedRequestsThrottled <= this.bufferedRequests);
            value = (double)this.bufferedRequestsThrottled / (double)this.bufferedRequests;
            this.smoothedThrottling = (this.smoothedThrottling - value) * Math.pow(weight, this.bufferedRequests) + value;
            this.infoTotalRequests += (long)this.bufferedRequests;
            this.infoTotalRequestsThrottled += (long)this.bufferedRequestsThrottled;
            this.bufferedRequests = 0;
            this.bufferedRequestsThrottled = 0;
        }
        if (throttlingKeys != 0) {
            value = (double)businessLogicTime / (double)throttlingKeys;
            this.smoothedTimePerKeyMillis = (this.smoothedTimePerKeyMillis - value) * Math.pow(weight, throttlingKeys) + value;
        }
        this.infoTotalTimeMillis += businessLogicTime;
    }

    @Override
    public void onUpdateSelectorSelectTime(long selectorSelectTime) {
        double extraThrottling;
        int throttlingKeys = this.lastSelectedKeys + this.concurrentTasksSize;
        double predictedTime = (double)throttlingKeys * this.smoothedTimePerKeyMillis;
        double newThrottling = this.smoothedThrottling - this.throttlingDecrease;
        if (newThrottling < 0.0) {
            newThrottling = 0.0;
        }
        if (predictedTime > (double)this.targetTimeMillis && (extraThrottling = 1.0 - (double)this.targetTimeMillis / predictedTime) > newThrottling) {
            newThrottling = extraThrottling;
            ++this.infoRoundsExceededTargetTime;
        }
        if (newThrottling == 0.0) {
            ++this.infoRoundsZeroThrottling;
        }
        ++this.infoRounds;
        this.throttling = (float)newThrottling;
    }

    @Override
    public void onUpdateSelectorSelectTimeout(long selectorSelectTimeout) {
    }

    @Override
    public void onUpdateSelectedKeyDuration(@NotNull Stopwatch sw) {
    }

    @Override
    public void onUpdateLocalTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw) {
    }

    @Override
    public void onUpdateLocalTasksStats(int newTasks, long loopTime) {
    }

    @Override
    public void onUpdateConcurrentTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw) {
    }

    @Override
    public void onUpdateScheduledTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw, boolean background) {
    }

    @Override
    public void onUpdateScheduledTasksStats(int newTasks, long loopTime, boolean background) {
    }

    @Override
    public void onFatalError(@NotNull Throwable e, Object causedObject) {
    }

    @Override
    public void onScheduledTaskOverdue(int overdue, boolean background) {
    }

    public double getAvgTimePerKeyMillis() {
        return this.smoothedTimePerKeyMillis;
    }

    @JmxAttribute
    public double getAvgKeysPerSecond() {
        return 1000.0 / this.smoothedTimePerKeyMillis;
    }

    @JmxAttribute
    public double getAvgThrottling() {
        return this.smoothedThrottling;
    }

    @JmxAttribute
    public Duration getTargetTime() {
        return Duration.ofMillis(this.targetTimeMillis);
    }

    @JmxAttribute
    public void setTargetTime(@NotNull Duration targetTime) {
        Preconditions.checkArgument((targetTime.toMillis() > 0L ? 1 : 0) != 0, (Object)"Target time should not be zero or less");
        this.targetTimeMillis = (int)targetTime.toMillis();
    }

    @JmxAttribute
    public Duration getGcTime() {
        return Duration.ofMillis(this.gcTimeMillis);
    }

    @JmxAttribute
    public void setGcTime(@NotNull Duration gcTime) {
        Preconditions.checkArgument((gcTime.toMillis() > 0L ? 1 : 0) != 0, (Object)"GC time should not be zero or less");
        this.gcTimeMillis = (int)gcTime.toMillis();
    }

    @JmxAttribute
    public double getThrottlingDecrease() {
        return this.throttlingDecrease;
    }

    @JmxAttribute
    public void setThrottlingDecrease(double throttlingDecrease) {
        Preconditions.checkArgument((throttlingDecrease >= 0.0 && throttlingDecrease <= 1.0 ? 1 : 0) != 0, (Object)"Throttling decrease should not fall out of [0;1] range");
        this.throttlingDecrease = throttlingDecrease;
    }

    @JmxAttribute
    public Duration getSmoothingWindow() {
        return Duration.ofMillis(this.smoothingWindow);
    }

    @JmxAttribute
    public void setSmoothingWindow(@NotNull Duration smoothingWindow) {
        Preconditions.checkArgument((smoothingWindow.toMillis() > 0L ? 1 : 0) != 0, (Object)"Smoothing window should not be zero or less");
        this.smoothingWindow = (int)smoothingWindow.toMillis();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalRequests() {
        return this.infoTotalRequests;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalRequestsThrottled() {
        return this.infoTotalRequestsThrottled;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalProcessed() {
        return this.infoTotalRequests - this.infoTotalRequestsThrottled;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalTimeMillis() {
        return this.infoTotalTimeMillis;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getRounds() {
        return this.infoRounds;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getRoundsZeroThrottling() {
        return this.infoRoundsZeroThrottling;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getRoundsExceededTargetTime() {
        return this.infoRoundsExceededTargetTime;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getInfoRoundsGc() {
        return this.infoRoundsGc;
    }

    @JmxAttribute
    public double getThrottling() {
        return this.throttling;
    }

    @JmxOperation
    public void resetInfo() {
        this.infoTotalRequests = 0L;
        this.infoTotalRequestsThrottled = 0L;
        this.infoTotalTimeMillis = 0L;
        this.infoRounds = 0L;
        this.infoRoundsZeroThrottling = 0L;
        this.infoRoundsExceededTargetTime = 0L;
    }

    @Override
    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    public String toString() {
        return String.format("{throttling:%2d%% avgKps=%-4d avgThrottling=%2d%% requests=%-4d throttled=%-4d rounds=%-3d zero=%-3d >targetTime=%-3d}", (int)(this.throttling * 100.0f), (int)this.getAvgKeysPerSecond(), (int)(this.smoothedThrottling * 100.0), this.infoTotalRequests, this.infoTotalRequestsThrottled, this.infoRounds, this.infoRoundsZeroThrottling, this.infoRoundsExceededTargetTime);
    }
}

