/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.common.time.CurrentTimeProvider;
import io.datakernel.eventloop.ScheduledRunnable;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public interface Scheduler
extends CurrentTimeProvider {
    @NotNull
    default public ScheduledRunnable schedule(@NotNull Instant instant, @NotNull Runnable runnable) {
        return this.schedule(instant.toEpochMilli(), runnable);
    }

    @NotNull
    public ScheduledRunnable schedule(long var1, @NotNull Runnable var3);

    @NotNull
    default public ScheduledRunnable delay(@NotNull Duration delay, @NotNull Runnable runnable) {
        return this.delay(delay.toMillis(), runnable);
    }

    @NotNull
    default public ScheduledRunnable delay(long delayMillis, @NotNull Runnable runnable) {
        return this.schedule(this.currentTimeMillis() + delayMillis, runnable);
    }

    @NotNull
    default public ScheduledRunnable scheduleBackground(@NotNull Instant instant, @NotNull Runnable runnable) {
        return this.scheduleBackground(instant.toEpochMilli(), runnable);
    }

    @NotNull
    public ScheduledRunnable scheduleBackground(long var1, @NotNull Runnable var3);

    @NotNull
    default public ScheduledRunnable delayBackground(@NotNull Duration delay, @NotNull Runnable runnable) {
        return this.delayBackground(delay.toMillis(), runnable);
    }

    @NotNull
    default public ScheduledRunnable delayBackground(long delayMillis, @NotNull Runnable runnable) {
        return this.scheduleBackground(this.currentTimeMillis() + delayMillis, runnable);
    }
}

