/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import org.jetbrains.annotations.NotNull;

public final class ScheduledRunnable
implements Comparable<ScheduledRunnable> {
    private final long timestamp;
    private Runnable runnable;
    private boolean cancelled;
    private boolean complete;

    private ScheduledRunnable(long timestamp, @NotNull Runnable runnable) {
        this.timestamp = timestamp;
        this.runnable = runnable;
    }

    public static ScheduledRunnable create(long timestamp, @NotNull Runnable runnable) {
        return new ScheduledRunnable(timestamp, runnable);
    }

    public void cancel() {
        this.cancelled = true;
        this.runnable = null;
    }

    public void complete() {
        this.complete = true;
        this.runnable = null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public int compareTo(ScheduledRunnable o) {
        return Long.compare(this.timestamp, o.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledRunnable that = (ScheduledRunnable)o;
        return this.timestamp == that.timestamp;
    }

    public int hashCode() {
        return (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    public String toString() {
        return "ScheduledRunnable{timestamp=" + this.timestamp + ", cancelled=" + this.cancelled + ", complete=" + this.complete + ", runnable=" + this.runnable + '}';
    }
}

